/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.util.StartsWithPredicate;

public final class CommandFlags
extends CommandElement {
    @Nullable
    private final CommandElement childElement;
    private final Map<List<String>, CommandElement> usageFlags;
    private final Map<String, CommandElement> shortFlags;
    private final Map<String, CommandElement> longFlags;
    private final UnknownFlagBehavior unknownShortFlagBehavior;
    private final UnknownFlagBehavior unknownLongFlagBehavior;
    private final boolean anchorFlags;

    protected CommandFlags(@Nullable CommandElement childElement, Map<List<String>, CommandElement> usageFlags, Map<String, CommandElement> shortFlags, Map<String, CommandElement> longFlags, UnknownFlagBehavior unknownShortFlagBehavior, UnknownFlagBehavior unknownLongFlagBehavior, boolean anchorFlags) {
        super(null);
        this.childElement = childElement;
        this.usageFlags = usageFlags;
        this.shortFlags = shortFlags;
        this.longFlags = longFlags;
        this.unknownShortFlagBehavior = unknownShortFlagBehavior;
        this.unknownLongFlagBehavior = unknownLongFlagBehavior;
        this.anchorFlags = anchorFlags;
    }

    @Override
    public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
        Object startIdx = args.getState();
        while (args.hasNext()) {
            String arg = args.next();
            if (arg.startsWith("-")) {
                boolean ignore;
                Object flagStartIdx = args.getState();
                if (arg.startsWith("--")) {
                    String longFlag = arg.substring(2);
                    ignore = !this.parseLongFlag(source, longFlag, args, context);
                } else {
                    boolean bl = ignore = !this.parseShortFlags(source, arg = arg.substring(1), args, context);
                }
                if (ignore) continue;
                args.removeArgs(flagStartIdx, args.getState());
                continue;
            }
            if (!this.anchorFlags) continue;
        }
        args.setState(startIdx);
        if (this.childElement != null) {
            this.childElement.parse(source, args, context);
        }
    }

    private boolean parseLongFlag(CommandSource source, String longFlag, CommandArgs args, CommandContext context) throws ArgumentParseException {
        block13: {
            CommandElement element;
            block14: {
                block11: {
                    CommandElement element2;
                    String value;
                    block12: {
                        if (!longFlag.contains("=")) break block11;
                        String[] flagSplit = longFlag.split("=", 2);
                        longFlag = flagSplit[0];
                        value = flagSplit[1];
                        element2 = this.longFlags.get(longFlag.toLowerCase());
                        if (element2 != null) break block12;
                        switch (this.unknownLongFlagBehavior) {
                            case ERROR: {
                                throw args.createError(SpongeApiTranslationHelper.t("Unknown long flag %s specified", args));
                            }
                            case ACCEPT_NONVALUE: 
                            case ACCEPT_VALUE: {
                                context.putArg(longFlag, (Object)value);
                                break block13;
                            }
                            case IGNORE: {
                                return false;
                            }
                            default: {
                                throw new Error("New UnknownFlagBehavior added without corresponding case clauses");
                            }
                        }
                    }
                    args.insertArg(value);
                    element2.parse(source, args, context);
                    break block13;
                }
                element = this.longFlags.get(longFlag.toLowerCase());
                if (element != null) break block14;
                switch (this.unknownLongFlagBehavior) {
                    case ERROR: {
                        throw args.createError(SpongeApiTranslationHelper.t("Unknown long flag %s specified", args));
                    }
                    case ACCEPT_NONVALUE: {
                        context.putArg(longFlag, (Object)true);
                        break block13;
                    }
                    case ACCEPT_VALUE: {
                        GenericArguments.string(Text.of(longFlag)).parse(source, args, context);
                        break block13;
                    }
                    case IGNORE: {
                        return false;
                    }
                    default: {
                        throw new Error("New UnknownFlagBehavior added without corresponding case clauses");
                    }
                }
            }
            element.parse(source, args, context);
        }
        return true;
    }

    private boolean parseShortFlags(CommandSource source, String shortFlags, CommandArgs args, CommandContext context) throws ArgumentParseException {
        block6: for (int i = 0; i < shortFlags.length(); ++i) {
            String flagChar = shortFlags.substring(i, i + 1);
            CommandElement element = this.shortFlags.get(flagChar);
            if (element == null) {
                switch (this.unknownShortFlagBehavior) {
                    case IGNORE: {
                        if (i == 0) {
                            return false;
                        }
                        throw args.createError(SpongeApiTranslationHelper.t("Unknown short flag %s specified", flagChar));
                    }
                    case ERROR: {
                        throw args.createError(SpongeApiTranslationHelper.t("Unknown short flag %s specified", flagChar));
                    }
                    case ACCEPT_NONVALUE: {
                        context.putArg(flagChar, (Object)true);
                        continue block6;
                    }
                    case ACCEPT_VALUE: {
                        GenericArguments.string(Text.of(flagChar)).parse(source, args, context);
                        continue block6;
                    }
                    default: {
                        throw new Error("New UnknownFlagBehavior added without corresponding case clauses");
                    }
                }
            }
            element.parse(source, args, context);
        }
        return true;
    }

    @Override
    public Text getUsage(CommandSource src) {
        ArrayList<Object> builder = new ArrayList<Object>();
        for (Map.Entry<List<String>, CommandElement> arg : this.usageFlags.entrySet()) {
            builder.add("[");
            Iterator<String> it = arg.getKey().iterator();
            while (it.hasNext()) {
                builder.add("-");
                builder.add(it.next());
                if (!it.hasNext()) continue;
                builder.add("|");
            }
            Text usage = arg.getValue().getUsage(src);
            if (usage.toPlain().trim().length() > 0) {
                builder.add(" ");
                builder.add(usage);
            }
            builder.add("]");
            builder.add(" ");
        }
        if (this.childElement != null) {
            builder.add(this.childElement.getUsage(src));
        }
        return Text.of(builder.toArray());
    }

    @Override
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        return null;
    }

    @Override
    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        Object startIdx = args.getState();
        while (args.hasNext()) {
            Optional<String> arg = args.nextIfPresent();
            if (arg.get().startsWith("-")) {
                String argStr;
                String longFlag;
                List<String> ret;
                Object flagStartIdx = args.getState();
                if (arg.get().startsWith("--") ? (ret = this.tabCompleteLongFlag(longFlag = arg.get().substring(2), src, args, context)) != null : (ret = this.tabCompleteShortFlags(argStr = arg.get().substring(1), src, args, context)) != null) {
                    return ret;
                }
                args.removeArgs(flagStartIdx, args.getState());
                continue;
            }
            if (!this.anchorFlags) continue;
        }
        args.setState(startIdx);
        if (this.childElement == null) {
            return Collections.emptyList();
        }
        return this.childElement.complete(src, args, context);
    }

    @Nullable
    private List<String> tabCompleteLongFlag(String longFlag, CommandSource src, CommandArgs args, CommandContext context) {
        if (longFlag.contains("=")) {
            String[] flagSplit = longFlag.split("=", 2);
            longFlag = flagSplit[0];
            String value = flagSplit[1];
            CommandElement element = this.longFlags.get(longFlag.toLowerCase());
            if (element == null) {
                context.putArg(longFlag, (Object)value);
            } else {
                args.insertArg(value);
                String finalLongFlag = longFlag;
                Object position = args.getState();
                try {
                    element.parse(src, args, context);
                }
                catch (ArgumentParseException ex) {
                    args.setState(position);
                    return ImmutableList.copyOf((Collection)element.complete(src, args, context).stream().map(input -> "--" + finalLongFlag + "=" + input).collect(Collectors.toList()));
                }
            }
        } else {
            CommandElement element = this.longFlags.get(longFlag.toLowerCase());
            if (element == null) {
                List retStrings = (List)this.longFlags.keySet().stream().filter(new StartsWithPredicate(longFlag)).map(arg -> "--" + arg).collect(ImmutableList.toImmutableList());
                if (retStrings.isEmpty() && this.unknownLongFlagBehavior == UnknownFlagBehavior.ACCEPT_VALUE) {
                    args.nextIfPresent();
                    return null;
                }
                return retStrings;
            }
            boolean complete = false;
            Object state = args.getState();
            try {
                element.parse(src, args, context);
            }
            catch (ArgumentParseException ex) {
                complete = true;
            }
            if (!args.hasNext()) {
                complete = true;
            }
            if (complete) {
                args.setState(state);
                return element.complete(src, args, context);
            }
        }
        return null;
    }

    @Nullable
    private List<String> tabCompleteShortFlags(String shortFlags, CommandSource src, CommandArgs args, CommandContext context) {
        for (int i = 0; i < shortFlags.length(); ++i) {
            String flagChar = shortFlags.substring(i, i + 1);
            CommandElement element = this.shortFlags.get(flagChar);
            if (element == null) {
                if (i != 0 || this.unknownShortFlagBehavior != UnknownFlagBehavior.ACCEPT_VALUE) continue;
                args.nextIfPresent();
                return null;
            }
            Object start = args.getState();
            try {
                element.parse(src, args, context);
                continue;
            }
            catch (ArgumentParseException ex) {
                args.setState(start);
                return element.complete(src, args, context);
            }
        }
        return null;
    }

    public static class Builder {
        private final Map<List<String>, CommandElement> usageFlags = new HashMap<List<String>, CommandElement>();
        private final Map<String, CommandElement> shortFlags = new HashMap<String, CommandElement>();
        private final Map<String, CommandElement> longFlags = new HashMap<String, CommandElement>();
        private UnknownFlagBehavior unknownLongFlagBehavior = UnknownFlagBehavior.ERROR;
        private UnknownFlagBehavior unknownShortFlagBehavior = UnknownFlagBehavior.ERROR;
        private boolean anchorFlags = false;
        private static final Function<String, CommandElement> MARK_TRUE_FUNC = new Function<String, CommandElement>(){

            @Override
            @Nullable
            public CommandElement apply(@Nullable String input) {
                return GenericArguments.markTrue(input);
            }
        };

        Builder() {
        }

        private Builder flag(Function<String, CommandElement> func, String ... specs) {
            ArrayList<String> availableFlags = new ArrayList<String>(specs.length);
            CommandElement el = null;
            for (String spec : specs) {
                if (spec.startsWith("-")) {
                    String flagKey = spec.substring(1);
                    if (el == null) {
                        el = func.apply(flagKey);
                    }
                    availableFlags.add(flagKey);
                    this.longFlags.put(flagKey.toLowerCase(), el);
                    continue;
                }
                for (int i = 0; i < spec.length(); ++i) {
                    String flagKey = spec.substring(i, i + 1);
                    if (el == null) {
                        el = func.apply(flagKey);
                    }
                    availableFlags.add(flagKey);
                    this.shortFlags.put(flagKey, el);
                }
            }
            this.usageFlags.put(availableFlags, el);
            return this;
        }

        public Builder flag(String ... specs) {
            return this.flag(MARK_TRUE_FUNC, specs);
        }

        public Builder permissionFlag(final String flagPermission, String ... specs) {
            return this.flag(new Function<String, CommandElement>(){

                @Override
                @Nullable
                public CommandElement apply(@Nullable String input) {
                    return GenericArguments.requiringPermission(GenericArguments.markTrue(input), flagPermission);
                }
            }, specs);
        }

        public Builder valueFlag(CommandElement value, String ... specs) {
            return this.flag((String ignore) -> value, specs);
        }

        public Builder setAcceptsArbitraryLongFlags(boolean acceptsArbitraryLongFlags) {
            this.setUnknownLongFlagBehavior(UnknownFlagBehavior.ACCEPT_NONVALUE);
            return this;
        }

        public Builder setUnknownLongFlagBehavior(UnknownFlagBehavior behavior) {
            this.unknownLongFlagBehavior = behavior;
            return this;
        }

        public Builder setUnknownShortFlagBehavior(UnknownFlagBehavior behavior) {
            this.unknownShortFlagBehavior = behavior;
            return this;
        }

        public Builder setAnchorFlags(boolean anchorFlags) {
            this.anchorFlags = anchorFlags;
            return this;
        }

        public CommandElement buildWith(CommandElement wrapped) {
            return new CommandFlags(wrapped, this.usageFlags, this.shortFlags, this.longFlags, this.unknownShortFlagBehavior, this.unknownLongFlagBehavior, this.anchorFlags);
        }
    }

    public static enum UnknownFlagBehavior {
        ERROR,
        ACCEPT_NONVALUE,
        ACCEPT_VALUE,
        IGNORE;

    }
}

