/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.mutable.common;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;

public abstract class AbstractBoundedComparableData<T extends Comparable<T>, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractSingleData<T, M, I> {
    protected final Comparator<T> comparator;
    protected final T lowerBound;
    protected final T upperBound;
    protected final T defaultValue;

    protected AbstractBoundedComparableData(T value, Key<MutableBoundedValue<T>> usedKey, Comparator<T> comparator, T lowerBound, T upperBound, T defaultValue) {
        super(value, usedKey);
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
        this.lowerBound = (Comparable)Preconditions.checkNotNull(lowerBound);
        this.upperBound = (Comparable)Preconditions.checkNotNull(upperBound);
        this.defaultValue = (Comparable)Preconditions.checkNotNull(defaultValue);
    }

    @Override
    protected MutableBoundedValue<T> getValueGetter() {
        return Sponge.getRegistry().getValueFactory().createBoundedValueBuilder(this.usedKey).defaultValue(this.defaultValue).comparator(this.comparator).minimum(this.lowerBound).maximum(this.upperBound).actualValue(this.getValue()).build();
    }

    @Override
    public M setValue(T value) {
        Preconditions.checkArgument((this.comparator.compare(this.lowerBound, value) >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.comparator.compare(this.upperBound, value) <= 0 ? 1 : 0) != 0);
        return super.setValue(value);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey.getQuery(), this.getValue());
    }
}

