/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.meta;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.item.Enchantment;

public final class ItemEnchantment
implements DataSerializable {
    private final Enchantment enchantment;
    private final int level;

    public ItemEnchantment(Enchantment enchantment, int level) {
        this.enchantment = (Enchantment)Preconditions.checkNotNull((Object)enchantment);
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"level must not be negative (was %s)", (int)level);
        Preconditions.checkArgument((level <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"level must not be greater than %s (was %s)", (int)Short.MAX_VALUE, (int)level);
        this.level = level;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.ENCHANTMENT_ID, (Object)this.enchantment.getId()).set(Queries.LEVEL, (Object)this.level);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enchantment, this.level});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemEnchantment other = (ItemEnchantment)obj;
        return Objects.equal((Object)this.enchantment, (Object)other.enchantment) && Objects.equal((Object)this.level, (Object)other.level);
    }
}

