/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.value.mutable;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;

public interface CompositeValueStore<S extends CompositeValueStore<S, H>, H extends ValueContainer<?>>
extends ValueContainer<S> {
    public <T extends H> Optional<T> get(Class<T> var1);

    default public <T extends H> T require(Class<T> containerClass) {
        Optional<T> optional = this.get(containerClass);
        if (optional.isPresent()) {
            return (T)((ValueContainer)optional.get());
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for container class '%s'", containerClass.getName()));
    }

    public <T extends H> Optional<T> getOrCreate(Class<T> var1);

    @Override
    public boolean supports(Class<? extends H> var1);

    default public <E> DataTransactionResult transform(Key<? extends BaseValue<E>> key, Function<E, E> function) {
        if (this.supports(key)) {
            return this.offer(key, Preconditions.checkNotNull(function.apply(this.get(key).orElse(null))));
        }
        return DataTransactionResult.failNoData();
    }

    public <E> DataTransactionResult offer(Key<? extends BaseValue<E>> var1, E var2);

    default public <E> DataTransactionResult tryOffer(Key<? extends BaseValue<E>> key, E value) throws IllegalArgumentException {
        DataTransactionResult result = this.offer(key, value);
        if (!result.isSuccessful()) {
            throw new IllegalArgumentException("Failed offer transaction!");
        }
        return result;
    }

    default public <E> DataTransactionResult offer(BaseValue<E> value) {
        return this.offer(value.getKey(), value.get());
    }

    default public <E> DataTransactionResult tryOffer(BaseValue<E> value) throws IllegalArgumentException {
        DataTransactionResult result = this.offer(value.getKey(), value.get());
        if (!result.isSuccessful()) {
            throw new IllegalArgumentException("Failed offer transaction!");
        }
        return result;
    }

    default public DataTransactionResult offer(H valueContainer) {
        return this.offer(valueContainer, MergeFunction.IGNORE_ALL);
    }

    public DataTransactionResult offer(H var1, MergeFunction var2);

    default public DataTransactionResult offer(Iterable<H> valueContainers) {
        return this.offer(valueContainers, MergeFunction.IGNORE_ALL);
    }

    default public DataTransactionResult offer(Iterable<H> valueContainers, MergeFunction function) {
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (ValueContainer valueContainer : valueContainers) {
            builder.absorbResult(this.offer(valueContainer, function));
        }
        return builder.build();
    }

    default public DataTransactionResult tryOffer(H valueContainer) {
        DataTransactionResult result = this.offer(valueContainer, MergeFunction.IGNORE_ALL);
        if (!result.isSuccessful()) {
            throw new IllegalArgumentException("Failed offer transaction!");
        }
        return result;
    }

    default public DataTransactionResult tryOffer(H valueContainer, MergeFunction function) throws IllegalArgumentException {
        DataTransactionResult result = this.offer(valueContainer, function);
        if (!result.isSuccessful()) {
            throw new IllegalArgumentException("Failed offer transaction!");
        }
        return result;
    }

    public DataTransactionResult remove(Class<? extends H> var1);

    default public DataTransactionResult remove(BaseValue<?> value) {
        return this.remove(value.getKey());
    }

    public DataTransactionResult remove(Key<?> var1);

    public DataTransactionResult undo(DataTransactionResult var1);

    default public DataTransactionResult copyFrom(S that) {
        return this.copyFrom(that, MergeFunction.IGNORE_ALL);
    }

    public DataTransactionResult copyFrom(S var1, MergeFunction var2);

    public Collection<H> getContainers();
}

