/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage.source.common;

import com.google.common.base.Preconditions;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.source.IndirectEntityDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractEntityDamageSource;

public abstract class AbstractIndirectEntityDamageSource
implements IndirectEntityDamageSource {
    private final DamageType apiDamageType;
    private final boolean absolute;
    private final boolean bypassesArmor;
    private final boolean scales;
    private final boolean explosive;
    private final boolean magic;
    private final boolean creative;
    private final Entity source;
    private final Entity indirect;

    protected AbstractIndirectEntityDamageSource(AbstractIndirectEntityDamageSourceBuilder<?, ?> builder) {
        this.apiDamageType = (DamageType)Preconditions.checkNotNull((Object)builder.damageType, (Object)"DamageType cannot be null!");
        this.absolute = builder.absolute;
        this.bypassesArmor = builder.bypasses;
        this.scales = builder.scales;
        this.explosive = builder.explosion;
        this.magic = builder.magical;
        this.creative = builder.creative;
        this.source = (Entity)Preconditions.checkNotNull((Object)builder.sourceEntity, (Object)"Entity source cannot be null!");
        this.indirect = (Entity)Preconditions.checkNotNull((Object)builder.indirect, (Object)"Indirect source cannot be null!");
    }

    @Override
    public Entity getSource() {
        return this.source;
    }

    @Override
    public DamageType getType() {
        return this.apiDamageType;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean isBypassingArmor() {
        return this.bypassesArmor;
    }

    @Override
    public boolean isScaledByDifficulty() {
        return this.scales;
    }

    @Override
    public boolean isExplosive() {
        return this.explosive;
    }

    @Override
    public boolean isMagic() {
        return this.magic;
    }

    @Override
    public boolean doesAffectCreative() {
        return this.creative;
    }

    @Override
    public Entity getIndirectSource() {
        return this.indirect;
    }

    public static abstract class AbstractIndirectEntityDamageSourceBuilder<T extends IndirectEntityDamageSource, B extends IndirectEntityDamageSource.AbstractBuilder<T, B>>
    extends AbstractEntityDamageSource.AbstractEntityDamageSourceBuilder<T, B>
    implements IndirectEntityDamageSource.AbstractBuilder<T, B> {
        protected Entity sourceEntity;
        protected Entity indirect;

        @Override
        public B entity(Entity entity) {
            this.sourceEntity = (Entity)Preconditions.checkNotNull((Object)entity, (Object)"Entity source cannot be null!");
            return (B)this;
        }

        @Override
        public B proxySource(Entity projectile) {
            this.indirect = (Entity)Preconditions.checkNotNull((Object)projectile);
            return (B)this;
        }

        @Override
        public B reset() {
            super.reset();
            this.sourceEntity = null;
            this.indirect = null;
            return (B)this;
        }
    }
}

