/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.schematic;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.world.extent.ArchetypeVolume;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.api.world.schematic.BlockPaletteType;

public interface Schematic
extends ArchetypeVolume {
    public static final String METADATA_NAME = "Name";
    public static final String METADATA_AUTHOR = "Author";
    public static final String METADATA_DATE = "Date";
    public static final String METADATA_REQUIRED_MODS = "RequiredMods";

    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public BlockPalette getPalette();

    public DataView getMetadata();

    @Override
    public MutableBlockVolumeWorker<Schematic> getBlockWorker();

    public static interface Builder
    extends ResettableBuilder<Schematic, Builder> {
        public Builder volume(ArchetypeVolume var1);

        public Builder volume(Extent var1);

        public Builder palette(BlockPalette var1);

        public Builder paletteType(BlockPaletteType var1);

        public Builder metadata(DataView var1);

        public Builder metaValue(String var1, Object var2);

        public Schematic build() throws IllegalArgumentException;
    }
}

