/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.block.tileentity;

import java.util.List;
import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.Banner;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.meta.PatternLayer;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.PatternListValue;
import org.spongepowered.common.data.builder.block.tileentity.AbstractTileBuilder;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeBannerData;
import org.spongepowered.common.data.util.DataQueries;

public class SpongeBannerBuilder
extends AbstractTileBuilder<Banner> {
    public SpongeBannerBuilder() {
        super(Banner.class, 1);
    }

    @Override
    protected Optional<Banner> buildContent(DataView container) throws InvalidDataException {
        return super.buildContent(container).flatMap(banner1 -> {
            if (!container.contains(DataQueries.BASE) || !container.contains(DataQueries.PATTERNS)) {
                ((TileEntity)banner1).func_145843_s();
                return Optional.empty();
            }
            SpongeBannerData bannerData = new SpongeBannerData();
            String dyeColorId = container.getString(DataQueries.BASE).get();
            Optional<DyeColor> colorOptional = Sponge.getRegistry().getType(DyeColor.class, dyeColorId);
            if (!colorOptional.isPresent()) {
                throw new InvalidDataException("The provided container has an invalid dye color entry!");
            }
            bannerData.set(Keys.BANNER_BASE_COLOR, colorOptional.get());
            List<PatternLayer> patternsList = container.getSerializableList(DataQueries.PATTERNS, PatternLayer.class).get();
            PatternListValue patternLayers = bannerData.patternsList();
            patternsList.forEach(patternLayers::add);
            bannerData.set((BaseValue<?>)patternLayers);
            banner1.offer(bannerData);
            ((TileEntityBanner)banner1).func_145829_t();
            return Optional.of(banner1);
        });
    }
}

