/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.item;

import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;

public class SpongeFireworkEffectDataBuilder
extends AbstractDataBuilder<FireworkEffect>
implements DataBuilder<FireworkEffect> {
    private static final int SUPPORTED_VERSION = 1;

    public SpongeFireworkEffectDataBuilder() {
        super(FireworkEffect.class, 1);
    }

    @Override
    protected Optional<FireworkEffect> buildContent(DataView container) throws InvalidDataException {
        if (container.contains(DataQueries.FIREWORK_SHAPE, DataQueries.FIREWORK_COLORS, DataQueries.FIREWORK_FADE_COLORS, DataQueries.FIREWORK_FLICKERS, DataQueries.FIREWORK_TRAILS)) {
            String fireworkShapeId = DataUtil.getData(container, DataQueries.FIREWORK_SHAPE, String.class);
            Optional<FireworkShape> shapeOptional = Sponge.getRegistry().getType(FireworkShape.class, fireworkShapeId);
            if (!shapeOptional.isPresent()) {
                throw new InvalidDataException("Could not find the FireworkShape for the provided id: " + fireworkShapeId);
            }
            FireworkShape shape = shapeOptional.get();
            boolean trails = DataUtil.getData(container, DataQueries.FIREWORK_TRAILS, Boolean.class);
            boolean flickers = DataUtil.getData(container, DataQueries.FIREWORK_FLICKERS, Boolean.class);
            List<Color> colors = container.getSerializableList(DataQueries.FIREWORK_COLORS, Color.class).get();
            List<Color> fadeColors = container.getSerializableList(DataQueries.FIREWORK_FADE_COLORS, Color.class).get();
            return Optional.of(FireworkEffect.builder().colors(colors).flicker(flickers).fades(fadeColors).trail(trails).shape(shape).build());
        }
        return Optional.empty();
    }
}

