/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.world;

import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class LocationBuilder
extends AbstractDataBuilder<Location<World>> {
    public LocationBuilder() {
        super(Location.class, 1);
    }

    @Override
    protected Optional<Location<World>> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Queries.WORLD_NAME, Queries.WORLD_ID, Queries.POSITION_X, Queries.POSITION_Y, Queries.POSITION_Z)) {
            return Optional.empty();
        }
        if (container.contains(Queries.CHUNK_X, Queries.CHUNK_Y, Queries.CHUNK_Z)) {
            return Optional.empty();
        }
        String worldId = container.getString(Queries.WORLD_ID).get();
        UUID worldUuid = UUID.fromString(worldId);
        Optional<World> world = Sponge.getGame().getServer().getWorld(worldUuid);
        if (!world.isPresent()) {
            throw new InvalidDataException("Could not find world by UUID: " + worldId);
        }
        double x = container.getDouble(Queries.POSITION_X).get();
        double y = container.getDouble(Queries.POSITION_Y).get();
        double z = container.getDouble(Queries.POSITION_Z).get();
        return Optional.of(new Location<Extent>((Extent)world.get(), x, y, z));
    }
}

