/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Collectors;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableMobSpawnerData;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.data.value.mutable.WeightedCollectionValue;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.data.manipulator.immutable.ImmutableSpongeMobSpawnerData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.util.ImplementationRequiredForTest;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeWeightedCollectionValue;

@ImplementationRequiredForTest
public class SpongeMobSpawnerData
extends AbstractData<MobSpawnerData, ImmutableMobSpawnerData>
implements MobSpawnerData {
    private short remainingDelay;
    private short minimumDelay;
    private short maximumDelay;
    private short count;
    private short maximumEntities;
    private short playerRange;
    private short spawnRange;
    private WeightedSerializableObject<EntityArchetype> nextEntityToSpawn;
    private WeightedTable<EntityArchetype> entities;

    public SpongeMobSpawnerData(short remainingDelay, short minimumDelay, short maximumDelay, short count, short maximumEntities, short playerRange, short spawnRange, WeightedSerializableObject<EntityArchetype> nextEntityToSpawn, WeightedTable<EntityArchetype> entities) {
        super(MobSpawnerData.class);
        this.remainingDelay = remainingDelay;
        this.minimumDelay = minimumDelay;
        this.maximumDelay = maximumDelay;
        this.count = count;
        this.maximumEntities = maximumEntities;
        this.playerRange = playerRange;
        this.spawnRange = spawnRange;
        this.nextEntityToSpawn = (WeightedSerializableObject)Preconditions.checkNotNull(nextEntityToSpawn);
        ((WeightedTable)Preconditions.checkNotNull(entities)).forEach(Preconditions::checkNotNull);
        this.entities = entities.stream().collect(Collectors.toCollection(WeightedTable::new));
        this.registerGettersAndSetters();
    }

    public SpongeMobSpawnerData() {
        this(20, 200, 800, 4, 6, 16, 4, DataConstants.DEFAULT_SPAWNER_NEXT_ENTITY_TO_SPAWN, new WeightedTable<EntityArchetype>());
    }

    @Override
    public MutableBoundedValue<Short> remainingDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_REMAINING_DELAY).minimum((short)0).maximum(this.maximumDelay).defaultValue((short)20).actualValue(this.remainingDelay).build();
    }

    @Override
    public MutableBoundedValue<Short> minimumSpawnDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MINIMUM_DELAY).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)200).actualValue(this.minimumDelay).build();
    }

    @Override
    public MutableBoundedValue<Short> maximumSpawnDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MAXIMUM_DELAY).minimum((short)1).maximum((short)Short.MAX_VALUE).defaultValue((short)800).actualValue(this.maximumDelay).build();
    }

    @Override
    public MutableBoundedValue<Short> spawnCount() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_SPAWN_COUNT).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)4).actualValue(this.count).build();
    }

    @Override
    public MutableBoundedValue<Short> maximumNearbyEntities() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)6).actualValue(this.maximumEntities).build();
    }

    @Override
    public MutableBoundedValue<Short> requiredPlayerRange() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_REQUIRED_PLAYER_RANGE).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)16).actualValue(this.playerRange).build();
    }

    @Override
    public MutableBoundedValue<Short> spawnRange() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_SPAWN_RANGE).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)4).actualValue(this.spawnRange).build();
    }

    @Override
    public Value<WeightedSerializableObject<EntityArchetype>> nextEntityToSpawn() {
        return new SpongeValue<WeightedSerializableObject<EntityArchetype>>(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, DataConstants.DEFAULT_SPAWNER_NEXT_ENTITY_TO_SPAWN, this.nextEntityToSpawn);
    }

    @Override
    public WeightedCollectionValue<EntityArchetype> possibleEntitiesToSpawn() {
        return new SpongeWeightedCollectionValue<EntityArchetype>(Keys.SPAWNER_ENTITIES, this.entities);
    }

    @Override
    public MobSpawnerData copy() {
        return new SpongeMobSpawnerData(this.remainingDelay, this.minimumDelay, this.maximumDelay, this.count, this.maximumEntities, this.playerRange, this.spawnRange, this.nextEntityToSpawn, this.entities);
    }

    @Override
    public ImmutableMobSpawnerData asImmutable() {
        return new ImmutableSpongeMobSpawnerData(this.remainingDelay, this.minimumDelay, this.maximumDelay, this.count, this.maximumEntities, this.playerRange, this.spawnRange, this.nextEntityToSpawn, this.entities);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.SPAWNER_REMAINING_DELAY.getQuery(), (Object)this.remainingDelay).set(Keys.SPAWNER_MINIMUM_DELAY.getQuery(), (Object)this.minimumDelay).set(Keys.SPAWNER_MAXIMUM_DELAY.getQuery(), (Object)this.maximumDelay).set(Keys.SPAWNER_SPAWN_COUNT.getQuery(), (Object)this.count).set(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES.getQuery(), (Object)this.maximumEntities).set(Keys.SPAWNER_REQUIRED_PLAYER_RANGE.getQuery(), (Object)this.playerRange).set(Keys.SPAWNER_SPAWN_RANGE.getQuery(), (Object)this.spawnRange).set(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN.getQuery(), this.nextEntityToSpawn).set(Keys.SPAWNER_ENTITIES.getQuery(), this.entities);
    }

    private void setEntities(WeightedTable<EntityArchetype> entities) {
        Preconditions.checkNotNull(entities);
        this.entities.clear();
        this.entities.addAll((Collection<TableEntry<EntityArchetype>>)entities);
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerKeyValue(Keys.SPAWNER_REMAINING_DELAY, this::remainingDelay);
        this.registerKeyValue(Keys.SPAWNER_MINIMUM_DELAY, this::minimumSpawnDelay);
        this.registerKeyValue(Keys.SPAWNER_MAXIMUM_DELAY, this::maximumSpawnDelay);
        this.registerKeyValue(Keys.SPAWNER_SPAWN_COUNT, this::spawnCount);
        this.registerKeyValue(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, this::maximumNearbyEntities);
        this.registerKeyValue(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, this::requiredPlayerRange);
        this.registerKeyValue(Keys.SPAWNER_SPAWN_RANGE, this::spawnRange);
        this.registerKeyValue(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, this::nextEntityToSpawn);
        this.registerKeyValue(Keys.SPAWNER_ENTITIES, this::possibleEntitiesToSpawn);
        this.registerFieldGetter(Keys.SPAWNER_REMAINING_DELAY, () -> this.remainingDelay);
        this.registerFieldGetter(Keys.SPAWNER_MINIMUM_DELAY, () -> this.minimumDelay);
        this.registerFieldGetter(Keys.SPAWNER_MAXIMUM_DELAY, () -> this.maximumDelay);
        this.registerFieldGetter(Keys.SPAWNER_SPAWN_COUNT, () -> this.count);
        this.registerFieldGetter(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, () -> this.maximumEntities);
        this.registerFieldGetter(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, () -> this.playerRange);
        this.registerFieldGetter(Keys.SPAWNER_SPAWN_RANGE, () -> this.spawnRange);
        this.registerFieldGetter(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, () -> this.nextEntityToSpawn);
        this.registerFieldGetter(Keys.SPAWNER_ENTITIES, () -> this.entities);
        this.registerFieldSetter(Keys.SPAWNER_REMAINING_DELAY, remaining -> {
            this.remainingDelay = (Short)Preconditions.checkNotNull((Object)remaining);
        });
        this.registerFieldSetter(Keys.SPAWNER_MINIMUM_DELAY, minDelay -> {
            this.minimumDelay = (Short)Preconditions.checkNotNull((Object)minDelay);
        });
        this.registerFieldSetter(Keys.SPAWNER_MAXIMUM_DELAY, maxDelay -> {
            this.maximumDelay = (Short)Preconditions.checkNotNull((Object)maxDelay);
        });
        this.registerFieldSetter(Keys.SPAWNER_SPAWN_COUNT, count -> {
            this.count = (Short)Preconditions.checkNotNull((Object)count);
        });
        this.registerFieldSetter(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, maxEntities -> {
            this.maximumEntities = (Short)Preconditions.checkNotNull((Object)maxEntities);
        });
        this.registerFieldSetter(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, playerRange -> {
            this.playerRange = (Short)Preconditions.checkNotNull((Object)playerRange);
        });
        this.registerFieldSetter(Keys.SPAWNER_SPAWN_RANGE, spawnRange -> {
            this.spawnRange = (Short)Preconditions.checkNotNull((Object)spawnRange);
        });
        this.registerFieldSetter(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, nextEntity -> {
            this.nextEntityToSpawn = (WeightedSerializableObject)Preconditions.checkNotNull((Object)nextEntity);
        });
        this.registerFieldSetter(Keys.SPAWNER_ENTITIES, this::setEntities);
    }
}

