/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.block;

import com.google.common.collect.Maps;
import java.util.Map;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableWireAttachmentData;
import org.spongepowered.api.data.manipulator.mutable.block.WireAttachmentData;
import org.spongepowered.api.data.type.WireAttachmentType;
import org.spongepowered.api.data.type.WireAttachmentTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeWireAttachmentData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeMapValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeWireAttachementData
extends AbstractData<WireAttachmentData, ImmutableWireAttachmentData>
implements WireAttachmentData {
    private Map<Direction, WireAttachmentType> wireAttachmentMap;

    public SpongeWireAttachementData(Map<Direction, WireAttachmentType> attachmentMap) {
        super(WireAttachmentData.class);
        this.wireAttachmentMap = Maps.newHashMap(attachmentMap);
        this.registerGettersAndSetters();
    }

    @Override
    public MapValue<Direction, WireAttachmentType> wireAttachments() {
        return new SpongeMapValue<Direction, WireAttachmentType>((Key<BaseValue<Map<Direction, WireAttachmentType>>>)Keys.WIRE_ATTACHMENTS, Maps.newHashMap(this.wireAttachmentMap));
    }

    @Override
    public Value<WireAttachmentType> wireAttachmentNorth() {
        return new SpongeValue<WireAttachmentType>(Keys.WIRE_ATTACHMENT_NORTH, WireAttachmentTypes.NONE, this.wireAttachmentMap.get((Object)Direction.NORTH));
    }

    @Override
    public Value<WireAttachmentType> wireAttachmentSouth() {
        return new SpongeValue<WireAttachmentType>(Keys.WIRE_ATTACHMENT_SOUTH, WireAttachmentTypes.NONE, this.wireAttachmentMap.get((Object)Direction.SOUTH));
    }

    @Override
    public Value<WireAttachmentType> wireAttachmentEast() {
        return new SpongeValue<WireAttachmentType>(Keys.WIRE_ATTACHMENT_EAST, WireAttachmentTypes.NONE, this.wireAttachmentMap.get((Object)Direction.EAST));
    }

    @Override
    public Value<WireAttachmentType> wireAttachmentWest() {
        return new SpongeValue<WireAttachmentType>(Keys.WIRE_ATTACHMENT_WEST, WireAttachmentTypes.NONE, this.wireAttachmentMap.get((Object)Direction.WEST));
    }

    @Override
    public WireAttachmentData copy() {
        return new SpongeWireAttachementData(this.wireAttachmentMap);
    }

    @Override
    public ImmutableWireAttachmentData asImmutable() {
        return new ImmutableSpongeWireAttachmentData(this.wireAttachmentMap);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.WIRE_ATTACHMENTS.getQuery(), this.wireAttachmentMap).set(Keys.WIRE_ATTACHMENT_NORTH.getQuery(), (Object)this.wireAttachmentMap.get((Object)Direction.NORTH).getId()).set(Keys.WIRE_ATTACHMENT_EAST.getQuery(), (Object)this.wireAttachmentMap.get((Object)Direction.EAST).getId()).set(Keys.WIRE_ATTACHMENT_SOUTH.getQuery(), (Object)this.wireAttachmentMap.get((Object)Direction.SOUTH).getId()).set(Keys.WIRE_ATTACHMENT_WEST.getQuery(), (Object)this.wireAttachmentMap.get((Object)Direction.WEST).getId());
    }

    @Override
    protected void registerGettersAndSetters() {
    }
}

