/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFuseData;
import org.spongepowered.api.data.manipulator.mutable.entity.FuseData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeFuseData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeFuseData
extends AbstractData<FuseData, ImmutableFuseData>
implements FuseData {
    private int fuseDuration;
    private int ticksRemaining;

    public SpongeFuseData(int fuseDuration, int ticksRemaining) {
        super(FuseData.class);
        this.fuseDuration = fuseDuration;
        this.ticksRemaining = ticksRemaining;
        this.registerGettersAndSetters();
    }

    public SpongeFuseData() {
        this(0, 0);
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.FUSE_DURATION, () -> this.fuseDuration);
        this.registerFieldSetter(Keys.FUSE_DURATION, fuseDuration -> {
            this.fuseDuration = fuseDuration;
        });
        this.registerKeyValue(Keys.FUSE_DURATION, this::fuseDuration);
        this.registerFieldGetter(Keys.TICKS_REMAINING, () -> this.ticksRemaining);
        this.registerFieldSetter(Keys.TICKS_REMAINING, ticksRemaining -> {
            this.ticksRemaining = ticksRemaining;
        });
        this.registerKeyValue(Keys.TICKS_REMAINING, this::ticksRemaining);
    }

    @Override
    public Value<Integer> fuseDuration() {
        return new SpongeValue<Integer>(Keys.FUSE_DURATION, this.fuseDuration);
    }

    @Override
    public Value<Integer> ticksRemaining() {
        return new SpongeValue<Integer>(Keys.TICKS_REMAINING, this.ticksRemaining);
    }

    @Override
    public FuseData copy() {
        return new SpongeFuseData(this.fuseDuration, this.ticksRemaining);
    }

    @Override
    public ImmutableFuseData asImmutable() {
        return new ImmutableSpongeFuseData(this.fuseDuration, this.ticksRemaining);
    }
}

