/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.item.SpongeFireworkEffectBuilder;
import org.spongepowered.common.item.SpongeFireworkShape;
import org.spongepowered.common.item.inventory.SpongeItemStackBuilder;

public class FireworkUtils {
    public static final BiMap<Byte, SpongeFireworkShape> shapeMapping = ImmutableBiMap.builder().put((Object)0, (Object)new SpongeFireworkShape(0, "BALL")).put((Object)1, (Object)new SpongeFireworkShape(1, "LARGE_BALL")).put((Object)2, (Object)new SpongeFireworkShape(2, "STAR")).put((Object)3, (Object)new SpongeFireworkShape(3, "CREEPER")).put((Object)4, (Object)new SpongeFireworkShape(4, "BURST")).build();

    public static ItemStack getItem(EntityFireworkRocket firework) {
        ItemStack item = (ItemStack)firework.func_184212_Q().func_187225_a(EntityFireworkRocket.field_184566_a);
        if (item.func_190926_b()) {
            item = (ItemStack)new SpongeItemStackBuilder().itemType(ItemTypes.FIREWORKS).build();
            firework.func_184212_Q().func_187227_b(EntityFireworkRocket.field_184566_a, (Object)item);
        }
        return item;
    }

    public static FireworkEffect getChargeEffect(ItemStack item) {
        Preconditions.checkArgument((item.func_77973_b() == Items.field_151154_bQ ? 1 : 0) != 0, (Object)"Item is not a firework!");
        NBTTagCompound firework = NbtDataUtil.getOrCreateCompound(item).func_74775_l("Explosion");
        if (firework == null) {
            return null;
        }
        return FireworkUtils.fromNbt(firework);
    }

    public static FireworkShape getShape(byte id) {
        if (id > 4) {
            id = 0;
        }
        return (FireworkShape)shapeMapping.get((Object)id);
    }

    public static byte getShapeId(FireworkShape shape) {
        return (Byte)shapeMapping.inverse().get((Object)shape);
    }

    public static FireworkEffect fromNbt(NBTTagCompound effectNbt) {
        SpongeFireworkEffectBuilder builder = new SpongeFireworkEffectBuilder();
        if (effectNbt.func_74764_b("Flicker")) {
            builder.flicker(effectNbt.func_74767_n("Flicker"));
        }
        if (effectNbt.func_74764_b("Trail")) {
            builder.trail(effectNbt.func_74767_n("Trail"));
        }
        if (effectNbt.func_74764_b("Type")) {
            byte type = effectNbt.func_74771_c("Type");
            builder.shape(FireworkUtils.getShape(type));
        }
        if (effectNbt.func_74764_b("Colors")) {
            int[] colorsRaw;
            ArrayList colors = Lists.newArrayList();
            for (int color : colorsRaw = effectNbt.func_74759_k("Colors")) {
                colors.add(Color.ofRgb(color));
            }
            builder.colors((Iterable<Color>)colors);
        }
        if (effectNbt.func_74764_b("FadeColors")) {
            int[] fadesRaw;
            ArrayList fades = Lists.newArrayList();
            for (int fade : fadesRaw = effectNbt.func_74759_k("FadeColors")) {
                fades.add(Color.ofRgb(fade));
            }
            builder.fades((Iterable<Color>)fades);
        }
        return builder.build();
    }

    public static NBTTagCompound toNbt(FireworkEffect effect) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("Flicker", effect.flickers());
        tag.func_74757_a("Trail", effect.hasTrail());
        tag.func_74774_a("Type", FireworkUtils.getShapeId(effect.getShape()));
        int[] colorsArray = new int[effect.getColors().size()];
        List<Color> colors = effect.getColors();
        for (int i = 0; i < colors.size(); ++i) {
            colorsArray[i] = colors.get(i).getRgb();
        }
        tag.func_74783_a("Colors", colorsArray);
        int[] fadeArray = new int[effect.getFadeColors().size()];
        List<Color> fades = effect.getFadeColors();
        for (int i = 0; i < fades.size(); ++i) {
            fadeArray[i] = fades.get(i).getRgb();
        }
        tag.func_74783_a("FadeColors", fadeArray);
        return tag;
    }

    public static boolean setFireworkEffects(Object object, List<FireworkEffect> effects) {
        ItemStack item = ItemStack.field_190927_a;
        if (object instanceof ItemStack) {
            item = (ItemStack)object;
        }
        if (object instanceof EntityFireworkRocket) {
            item = FireworkUtils.getItem((EntityFireworkRocket)object);
        }
        if (item.func_190926_b()) {
            return false;
        }
        if (item.func_77973_b() == Items.field_151154_bQ) {
            if (effects.size() != 0) {
                NbtDataUtil.getOrCreateCompound(item).func_74782_a("Explosion", (NBTBase)FireworkUtils.toNbt(effects.get(0)));
            } else {
                NbtDataUtil.getOrCreateCompound(item).func_82580_o("Explosion");
            }
            return true;
        }
        if (item.func_77973_b() == Items.field_151152_bP) {
            NBTTagList nbtEffects = new NBTTagList();
            effects.stream().map(FireworkUtils::toNbt).forEach(arg_0 -> ((NBTTagList)nbtEffects).func_74742_a(arg_0));
            NBTTagCompound fireworks = item.func_190925_c("Fireworks");
            fireworks.func_74782_a("Explosions", (NBTBase)nbtEffects);
            return true;
        }
        return false;
    }

    public static Optional<List<FireworkEffect>> getFireworkEffects(Object object) {
        Object effects;
        ItemStack item = ItemStack.field_190927_a;
        if (object instanceof ItemStack) {
            item = (ItemStack)object;
        }
        if (object instanceof EntityFireworkRocket) {
            item = FireworkUtils.getItem((EntityFireworkRocket)object);
        }
        if (item.func_190926_b()) {
            return Optional.empty();
        }
        if (item.func_77973_b() == Items.field_151152_bP) {
            NBTTagCompound fireworks = item.func_179543_a("Fireworks");
            if (fireworks == null || !fireworks.func_74764_b("Explosions")) {
                return Optional.empty();
            }
            NBTTagList effectsNbt = fireworks.func_150295_c("Explosions", 10);
            effects = Lists.newArrayList();
            for (int i = 0; i < effectsNbt.func_74745_c(); ++i) {
                NBTTagCompound effectNbt = effectsNbt.func_150305_b(i);
                effects.add(FireworkUtils.fromNbt(effectNbt));
            }
        } else {
            FireworkEffect effect = FireworkUtils.getChargeEffect(item);
            if (effect == null) {
                return Optional.empty();
            }
            effects = ImmutableList.of((Object)effect);
        }
        return Optional.of(effects);
    }

    public static boolean removeFireworkEffects(Object object) {
        ItemStack item = ItemStack.field_190927_a;
        if (object instanceof ItemStack) {
            item = (ItemStack)object;
        }
        if (object instanceof EntityFireworkRocket) {
            item = FireworkUtils.getItem((EntityFireworkRocket)object);
        }
        if (item.func_190926_b()) {
            return false;
        }
        if (item.func_77973_b() == Items.field_151154_bQ) {
            NbtDataUtil.getOrCreateCompound(item).func_82580_o("Explosion");
            return true;
        }
        if (item.func_77973_b() == Items.field_151152_bP) {
            NBTTagCompound fireworks = item.func_190925_c("Fireworks");
            fireworks.func_82580_o("Explosions");
            return true;
        }
        return false;
    }
}

