/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableInvulnerabilityData;
import org.spongepowered.api.data.manipulator.mutable.entity.InvulnerabilityData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeInvulnerabilityData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.util.ComparatorUtil;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeBoundedValue;

public final class InvulnerabilityDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, Integer, MutableBoundedValue<Integer>, InvulnerabilityData, ImmutableInvulnerabilityData> {
    public InvulnerabilityDataProcessor() {
        super(Entity.class, Keys.INVULNERABILITY_TICKS);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer actualValue) {
        return SpongeValueFactory.boundedBuilder(Keys.INVULNERABILITY_TICKS).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).actualValue(actualValue).build();
    }

    @Override
    protected boolean set(Entity dataHolder, Integer value) {
        dataHolder.field_70172_ad = value;
        if (dataHolder instanceof EntityLivingBase) {
            ((EntityLivingBase)dataHolder).field_70737_aN = value;
        }
        return true;
    }

    @Override
    protected Optional<Integer> getVal(Entity dataHolder) {
        return Optional.of(dataHolder.field_70172_ad);
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return ImmutableSpongeBoundedValue.cachedOf(Keys.INVULNERABILITY_TICKS, 0, value, ComparatorUtil.intComparator(), 0, Integer.MAX_VALUE);
    }

    @Override
    protected InvulnerabilityData createManipulator() {
        return new SpongeInvulnerabilityData();
    }
}

