/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.projectile.EntityArrow;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableKnockbackData;
import org.spongepowered.api.data.manipulator.mutable.entity.KnockbackData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeKnockbackData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class KnockbackDataProcessor
extends AbstractEntitySingleDataProcessor<EntityArrow, Integer, MutableBoundedValue<Integer>, KnockbackData, ImmutableKnockbackData> {
    public KnockbackDataProcessor() {
        super(EntityArrow.class, Keys.KNOCKBACK_STRENGTH);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer actualValue) {
        return SpongeValueFactory.boundedBuilder(Keys.KNOCKBACK_STRENGTH).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue(actualValue).build();
    }

    @Override
    protected boolean set(EntityArrow entity, Integer value) {
        entity.func_70240_a(value.intValue());
        return true;
    }

    @Override
    protected Optional<Integer> getVal(EntityArrow entity) {
        return Optional.of(entity.field_70256_ap);
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return new ImmutableSpongeValue<Integer>(Keys.KNOCKBACK_STRENGTH, value);
    }

    @Override
    protected KnockbackData createManipulator() {
        return new SpongeKnockbackData();
    }
}

