/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableStuckArrowsData;
import org.spongepowered.api.data.manipulator.mutable.entity.StuckArrowsData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeStuckArrowsData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.util.ComparatorUtil;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeBoundedValue;

public class StuckArrowsDataProcessor
extends AbstractEntitySingleDataProcessor<EntityLivingBase, Integer, MutableBoundedValue<Integer>, StuckArrowsData, ImmutableStuckArrowsData> {
    public StuckArrowsDataProcessor() {
        super(EntityLivingBase.class, Keys.STUCK_ARROWS);
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer actualValue) {
        return SpongeValueFactory.boundedBuilder(this.key).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue(actualValue).build();
    }

    @Override
    protected boolean set(EntityLivingBase entity, Integer arrows) {
        Preconditions.checkArgument((arrows >= 0 ? 1 : 0) != 0, (Object)"Stuck arrows must be greater than or equal to zero");
        entity.func_85034_r(arrows.intValue());
        return true;
    }

    @Override
    protected Optional<Integer> getVal(EntityLivingBase entity) {
        return Optional.of(entity.func_85035_bI());
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return new ImmutableSpongeBoundedValue<Integer>(this.key, 0, value, ComparatorUtil.intComparator(), 0, Integer.MAX_VALUE);
    }

    @Override
    protected StuckArrowsData createManipulator() {
        return new SpongeStuckArrowsData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

