/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.passive.EntityWolf;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableWetData;
import org.spongepowered.api.data.manipulator.mutable.WetData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.SpongeWetData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class WolfWetDataProcessor
extends AbstractEntitySingleDataProcessor<EntityWolf, Boolean, Value<Boolean>, WetData, ImmutableWetData> {
    public WolfWetDataProcessor() {
        super(EntityWolf.class, Keys.IS_WET);
    }

    @Override
    protected boolean set(EntityWolf entity, Boolean value) {
        if (value.booleanValue()) {
            entity.field_70925_g = true;
            entity.field_70928_h = true;
            entity.field_70929_i = 0.0f;
            entity.field_70927_j = 0.0f;
        } else {
            entity.field_70925_g = false;
            entity.field_70928_h = false;
            entity.field_70929_i = 0.0f;
            entity.field_70927_j = 0.0f;
        }
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(EntityWolf entity) {
        boolean isWet = entity.field_70925_g || entity.field_70928_h;
        return Optional.of(isWet);
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(Keys.IS_WET, false, actualValue);
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.IS_WET, false, value);
    }

    @Override
    protected WetData createManipulator() {
        return new SpongeWetData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

