/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableEnchantmentData;
import org.spongepowered.api.data.manipulator.mutable.item.EnchantmentData;
import org.spongepowered.api.data.meta.ItemEnchantment;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeEnchantmentData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;

public class ItemEnchantmentDataProcessor
extends AbstractItemSingleDataProcessor<List<ItemEnchantment>, ListValue<ItemEnchantment>, EnchantmentData, ImmutableEnchantmentData> {
    public ItemEnchantmentDataProcessor() {
        super((ItemStack input) -> true, Keys.ITEM_ENCHANTMENTS);
    }

    @Override
    protected EnchantmentData createManipulator() {
        return new SpongeEnchantmentData();
    }

    @Override
    protected boolean set(ItemStack itemStack, List<ItemEnchantment> value) {
        NbtDataUtil.setItemEnchantments(itemStack, value);
        return true;
    }

    @Override
    protected Optional<List<ItemEnchantment>> getVal(ItemStack itemStack) {
        if (itemStack.func_77948_v()) {
            return Optional.of(NbtDataUtil.getItemEnchantments(itemStack));
        }
        return Optional.empty();
    }

    @Override
    protected ListValue<ItemEnchantment> constructValue(List<ItemEnchantment> actualValue) {
        return new SpongeListValue<ItemEnchantment>(Keys.ITEM_ENCHANTMENTS, actualValue);
    }

    @Override
    protected ImmutableValue<List<ItemEnchantment>> constructImmutableValue(List<ItemEnchantment> value) {
        return new ImmutableSpongeListValue<ItemEnchantment>(Keys.ITEM_ENCHANTMENTS, ImmutableList.copyOf(value));
    }

    @Override
    public Optional<EnchantmentData> fill(DataContainer container, EnchantmentData enchantmentData) {
        DataUtil.checkDataExists(container, Keys.ITEM_ENCHANTMENTS.getQuery());
        List<ItemEnchantment> enchantments = container.getSerializableList(Keys.ITEM_ENCHANTMENTS.getQuery(), ItemEnchantment.class).get();
        ListValue<ItemEnchantment> existing = enchantmentData.enchantments();
        existing.addAll(enchantments);
        enchantmentData.set((BaseValue<?>)existing);
        return Optional.of(enchantmentData);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (container instanceof ItemStack) {
            ItemStack stack = (ItemStack)container;
            Optional<List<ItemEnchantment>> old = this.getVal(stack);
            if (!old.isPresent()) {
                return DataTransactionResult.successNoData();
            }
            stack.func_77978_p().func_82580_o("ench");
            return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
        }
        return DataTransactionResult.failNoData();
    }
}

