/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableStoredEnchantmentData;
import org.spongepowered.api.data.manipulator.mutable.item.StoredEnchantmentData;
import org.spongepowered.api.data.meta.ItemEnchantment;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.item.Enchantment;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeStoredEnchantmentData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class StoredEnchantmentDataProcessor
extends AbstractItemSingleDataProcessor<List<ItemEnchantment>, ListValue<ItemEnchantment>, StoredEnchantmentData, ImmutableStoredEnchantmentData> {
    public StoredEnchantmentDataProcessor() {
        super((ItemStack stack) -> stack.func_77973_b().equals(Items.field_151134_bR), Keys.STORED_ENCHANTMENTS);
    }

    @Override
    protected ListValue<ItemEnchantment> constructValue(List<ItemEnchantment> actualValue) {
        return SpongeValueFactory.getInstance().createListValue(Keys.STORED_ENCHANTMENTS, actualValue, Lists.newArrayList());
    }

    @Override
    protected boolean set(ItemStack entity, List<ItemEnchantment> value) {
        if (!entity.func_77942_o()) {
            entity.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = new NBTTagList();
        for (ItemEnchantment enchantment : value) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("id", (short)net.minecraft.enchantment.Enchantment.func_185258_b((net.minecraft.enchantment.Enchantment)((net.minecraft.enchantment.Enchantment)enchantment.getEnchantment())));
            tag.func_74777_a("lvl", (short)enchantment.getLevel());
            list.func_74742_a((NBTBase)tag);
        }
        entity.func_77978_p().func_74782_a("StoredEnchantments", (NBTBase)list);
        return true;
    }

    @Override
    protected Optional<List<ItemEnchantment>> getVal(ItemStack entity) {
        if (!entity.func_77942_o() || !entity.func_77978_p().func_150297_b("StoredEnchantments", 9)) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList();
        NBTTagList tags = entity.func_77978_p().func_150295_c("StoredEnchantments", 10);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound tag = tags.func_150305_b(i);
            list.add(new ItemEnchantment((Enchantment)net.minecraft.enchantment.Enchantment.func_185262_c((int)tag.func_74765_d("id")), tag.func_74765_d("lvl")));
        }
        return Optional.of(list);
    }

    @Override
    protected ImmutableValue<List<ItemEnchantment>> constructImmutableValue(List<ItemEnchantment> value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    protected StoredEnchantmentData createManipulator() {
        return new SpongeStoredEnchantmentData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (this.supports(container)) {
            ItemStack stack = (ItemStack)container;
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("StoredEnchantments", 10)) {
                stack.func_77978_p().func_82580_o("StoredEnchantments");
            }
            return DataTransactionResult.successNoData();
        }
        return DataTransactionResult.failNoData();
    }
}

