/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.tileentity;

import java.util.Optional;
import net.minecraft.tileentity.TileEntityHopper;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableCooldownData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.CooldownData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeCooldownData;
import org.spongepowered.common.data.processor.common.AbstractTileEntitySingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class CooldownDataProcessor
extends AbstractTileEntitySingleDataProcessor<TileEntityHopper, Integer, MutableBoundedValue<Integer>, CooldownData, ImmutableCooldownData> {
    public CooldownDataProcessor() {
        super(TileEntityHopper.class, Keys.COOLDOWN);
    }

    @Override
    public boolean set(TileEntityHopper entity, Integer value) {
        if (value < 1) {
            return false;
        }
        entity.field_145901_j = value;
        return true;
    }

    @Override
    public Optional<Integer> getVal(TileEntityHopper entity) {
        return Optional.ofNullable(entity.field_145901_j < 1 ? null : Integer.valueOf(entity.field_145901_j));
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer value) {
        return SpongeValueFactory.boundedBuilder(Keys.COOLDOWN).minimum(1).maximum(Integer.MAX_VALUE).defaultValue(8).actualValue(value).build();
    }

    @Override
    public ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public CooldownData createManipulator() {
        return new SpongeCooldownData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (container instanceof TileEntityHopper) {
            TileEntityHopper hopper = (TileEntityHopper)container;
            Optional<Integer> old = this.getVal(hopper);
            if (!old.isPresent()) {
                return DataTransactionResult.successNoData();
            }
            hopper.field_145901_j = -1;
            return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
        }
        return DataTransactionResult.failNoData();
    }
}

