/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;

public class FirstJoinValueProcessor
extends AbstractSpongeValueProcessor<EntityPlayer, Instant, Value<Instant>> {
    public FirstJoinValueProcessor() {
        super(EntityPlayer.class, Keys.FIRST_DATE_PLAYED);
    }

    @Override
    protected Value<Instant> constructValue(Instant actualValue) {
        return new SpongeValue<Instant>(Keys.FIRST_DATE_PLAYED, Instant.now(), actualValue);
    }

    @Override
    protected boolean set(EntityPlayer container, Instant value) {
        UUID id = container.func_110124_au();
        Instant played = SpongePlayerDataHandler.getLastPlayed(id).orElse(Instant.now());
        SpongePlayerDataHandler.setPlayerInfo(id, value, played);
        return true;
    }

    @Override
    protected Optional<Instant> getVal(EntityPlayer container) {
        return SpongePlayerDataHandler.getFirstJoined(container.func_110124_au());
    }

    @Override
    protected ImmutableValue<Instant> constructImmutableValue(Instant value) {
        return new ImmutableSpongeValue<Instant>(Keys.FIRST_DATE_PLAYED, Instant.now(), value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

