/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class VehicleValueProcessor
extends AbstractSpongeValueProcessor<Entity, EntitySnapshot, Value<EntitySnapshot>> {
    public VehicleValueProcessor() {
        super(Entity.class, Keys.VEHICLE);
    }

    @Override
    public boolean supports(ValueContainer<?> container) {
        return container instanceof Entity;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (container instanceof Entity) {
            Entity entity = (Entity)container;
            if (entity.func_184218_aH()) {
                org.spongepowered.api.entity.Entity vehicle = (org.spongepowered.api.entity.Entity)entity.func_184187_bx();
                entity.func_184210_p();
                return DataTransactionResult.successResult(new ImmutableSpongeValue<EntitySnapshot>(Keys.VEHICLE, vehicle.createSnapshot()));
            }
            return DataTransactionResult.builder().result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected Value<EntitySnapshot> constructValue(EntitySnapshot defaultValue) {
        return new SpongeValue<EntitySnapshot>(this.getKey(), defaultValue);
    }

    @Override
    protected boolean set(Entity container, EntitySnapshot value) {
        return ((org.spongepowered.api.entity.Entity)container).setVehicle(value.restore().orElse(null));
    }

    @Override
    protected Optional<EntitySnapshot> getVal(Entity container) {
        org.spongepowered.api.entity.Entity entity = (org.spongepowered.api.entity.Entity)container.field_184239_as;
        if (entity == null) {
            return Optional.empty();
        }
        return Optional.of(entity.createSnapshot());
    }

    @Override
    protected ImmutableValue<EntitySnapshot> constructImmutableValue(EntitySnapshot value) {
        return new ImmutableSpongeValue<EntitySnapshot>(this.getKey(), value);
    }
}

