/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.EnumDyeColor;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class WolfDyeColorValueProcessor
extends AbstractSpongeValueProcessor<EntityWolf, DyeColor, Value<DyeColor>> {
    public WolfDyeColorValueProcessor() {
        super(EntityWolf.class, Keys.DYE_COLOR);
    }

    @Override
    protected Value<DyeColor> constructValue(DyeColor actualValue) {
        return SpongeValueFactory.getInstance().createValue(Keys.DYE_COLOR, actualValue, DyeColors.BLACK);
    }

    @Override
    protected boolean set(EntityWolf container, DyeColor value) {
        container.func_175547_a((EnumDyeColor)value);
        return true;
    }

    @Override
    protected Optional<DyeColor> getVal(EntityWolf container) {
        return Optional.of((DyeColor)container.func_175546_cu());
    }

    @Override
    protected ImmutableValue<DyeColor> constructImmutableValue(DyeColor value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

