/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.event.AnnotatedEventListener;
import org.spongepowered.common.event.filter.EventFilter;
import org.spongepowered.common.event.filter.FilterFactory;

public final class InvokeEventListenerFactory
implements AnnotatedEventListener.Factory {
    private FilterFactory filterFactory;

    public InvokeEventListenerFactory(FilterFactory factory) {
        this.filterFactory = (FilterFactory)Preconditions.checkNotNull((Object)factory, (Object)"filterFactory");
    }

    @Override
    public AnnotatedEventListener create(Object handle, Method method) throws Exception {
        EventFilter filter = this.filterFactory.createFilter(method).newInstance();
        if (filter == null && method.getParameterCount() != 1) {
            throw new IllegalStateException("Failed to generate EventFilter for non trivial filtering operation.");
        }
        return new InvokeEventHandler(handle, method, filter);
    }

    private static class InvokeEventHandler
    extends AnnotatedEventListener {
        private final Method method;
        private final EventFilter filter;

        InvokeEventHandler(Object handle, Method method, EventFilter filter) {
            super(handle);
            this.method = (Method)Preconditions.checkNotNull((Object)method, (Object)"method");
            this.filter = filter;
        }

        @Override
        public void handle(Event event) throws Exception {
            if (this.filter != null) {
                Object[] filtered = this.filter.filter(event);
                if (filtered != null) {
                    StringBuilder args = new StringBuilder();
                    for (Object o : filtered) {
                        args.append(o.getClass().getName()).append(" ");
                    }
                    this.method.invoke(this.handle, filtered);
                }
            } else {
                this.method.invoke(this.handle, event);
            }
        }
    }
}

