/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.base.CaseFormat;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class ListenerChecker {
    private static final boolean ALL_TRUE = Boolean.parseBoolean(System.getProperty("sponge.shouldFireAll", "").toLowerCase());
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("sponge.debugShouldFire", "").toLowerCase());
    private final Class<?> clazz;
    private Map<String, Field> fields = new HashMap<String, Field>();
    private LoadingCache<Class<?>, Optional<Field>> fieldCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<Field>>(){

        public Optional<Field> load(Class<?> key) throws Exception {
            return Optional.ofNullable(ListenerChecker.this.fields.get(ListenerChecker.getName(key)));
        }
    });
    private LoadingCache<Class<?>, Set<Class<?>>> subtypeMappings = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Set<Class<?>>>(){

        public Set<Class<?>> load(Class<?> key) throws Exception {
            return new HashSet();
        }
    });

    private static String getName(Class<?> clazz) {
        String name = clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1).replace("$", "");
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
    }

    public <T> void registerListenerFor(Class<T> eventClass) {
        Set types = TypeToken.of(eventClass).getTypes().rawTypes();
        for (Class type : types) {
            ((Set)this.subtypeMappings.getUnchecked((Object)type)).add(eventClass);
        }
        this.updateFields(types, c -> true);
    }

    public <T> void unregisterListenerFor(Class<T> eventClass) {
        Set types = TypeToken.of(eventClass).getTypes().rawTypes();
        for (Class type : types) {
            ((Set)this.subtypeMappings.getUnchecked((Object)type)).remove(eventClass);
        }
        this.updateFields(types, c -> !((Set)this.subtypeMappings.getUnchecked(c)).isEmpty());
    }

    public ListenerChecker(Class<?> clazz) {
        this.clazz = clazz;
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            this.fields.put(field.getName(), field);
            if (!ALL_TRUE) continue;
            if (DEBUG) {
                System.err.println(String.format("Forcing field %s to true!", field.getName()));
            }
            try {
                field.set(null, true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public <T> void updateFields(Collection<Class<? super T>> classes, Predicate<Class<?>> enable) {
        if (ALL_TRUE) {
            return;
        }
        for (Class<T> clazz : classes) {
            ((Optional)this.fieldCache.getUnchecked(clazz)).ifPresent(f -> {
                boolean isEnabled = enable.test(clazz);
                if (DEBUG) {
                    System.err.println(String.format("Updating field for class %s with value %s", clazz.getName(), isEnabled));
                }
                try {
                    f.set(null, isEnabled);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

