/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.CapturedMultiMapSupplier;
import org.spongepowered.common.event.tracking.CapturedSupplier;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.ItemDropData;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.general.CommandState;
import org.spongepowered.common.event.tracking.phase.general.CompletePhase;
import org.spongepowered.common.event.tracking.phase.general.ExplosionState;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.event.tracking.phase.general.PostState;
import org.spongepowered.common.event.tracking.phase.general.TileEntityUnloadState;
import org.spongepowered.common.event.tracking.phase.general.WorldUnload;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeProxyBlockAccess;

public final class GeneralPhase
extends TrackingPhase {
    public static GeneralPhase getInstance() {
        return Holder.INSTANCE;
    }

    private GeneralPhase() {
    }

    @Override
    public void unwind(IPhaseState state, PhaseContext phaseContext) {
        ((GeneralState)state).unwind(phaseContext);
    }

    @Override
    public void postDispatch(IPhaseState unwindingState, PhaseContext unwindingContext, PhaseContext postContext) {
        List<BlockSnapshot> contextBlocks = postContext.getCapturedBlockSupplier().orEmptyList();
        List<Entity> contextEntities = postContext.getCapturedEntitySupplier().orEmptyList();
        List<EntityItem> contextItems = postContext.getCapturedItemsSupplier().orEmptyList();
        if (contextBlocks.isEmpty() && contextEntities.isEmpty() && contextItems.isEmpty()) {
            return;
        }
        if (!contextBlocks.isEmpty()) {
            ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>(contextBlocks);
            contextBlocks.clear();
            GeneralPhase.processBlockTransactionListsPost(postContext, blockSnapshots, unwindingState, unwindingContext);
        }
        if (!contextEntities.isEmpty()) {
            ArrayList<Entity> entities = new ArrayList<Entity>(contextEntities);
            contextEntities.clear();
            unwindingState.getPhase().processPostEntitySpawns(unwindingState, unwindingContext, entities);
        }
        if (!contextItems.isEmpty()) {
            ArrayList<EntityItem> items = new ArrayList<EntityItem>(contextItems);
            contextItems.clear();
            unwindingState.getPhase().processPostItemSpawns(unwindingState, items);
        }
    }

    public static void processBlockTransactionListsPost(PhaseContext postContext, List<BlockSnapshot> snapshotsToProcess, IPhaseState unwindingState, PhaseContext unwinding) {
        ArrayList<Transaction> invalidTransactions = new ArrayList<Transaction>();
        ImmutableList[] transactionArrays = new ImmutableList[5];
        ImmutableList.Builder[] transactionBuilders = new ImmutableList.Builder[5];
        for (int i = 0; i < 5; ++i) {
            transactionBuilders[i] = new ImmutableList.Builder();
        }
        ArrayList<ChangeBlockEvent> blockEvents = new ArrayList<ChangeBlockEvent>();
        for (BlockSnapshot snapshot : snapshotsToProcess) {
            TrackingUtil.TRANSACTION_PROCESSOR.apply(transactionBuilders).accept(TrackingUtil.TRANSACTION_CREATION.apply(snapshot));
        }
        for (int i = 0; i < 5; ++i) {
            transactionArrays[i] = transactionBuilders[i].build();
        }
        ChangeBlockEvent[] mainEvents = new ChangeBlockEvent[BlockChange.values().length];
        TrackingUtil.iterateChangeBlockEvents(transactionArrays, blockEvents, mainEvents);
        ChangeBlockEvent.Post postEvent = TrackingUtil.throwMultiEventsAndCreatePost(transactionArrays, blockEvents, mainEvents);
        if (postEvent == null) {
            return;
        }
        for (ChangeBlockEvent changeBlockEvent : blockEvents) {
            if (!changeBlockEvent.isCancelled()) continue;
            for (Transaction transaction : Lists.reverse(changeBlockEvent.getTransactions())) {
                transaction.setValid(false);
            }
        }
        if (postEvent.isCancelled()) {
            for (Transaction transaction : postEvent.getTransactions()) {
                transaction.setValid(false);
            }
        }
        for (Transaction transaction : postEvent.getTransactions()) {
            if (transaction.isValid()) continue;
            invalidTransactions.add(transaction);
        }
        if (!invalidTransactions.isEmpty()) {
            for (Transaction transaction : Lists.reverse(invalidTransactions)) {
                ((BlockSnapshot)transaction.getOriginal()).restore(true, BlockChangeFlag.NONE);
                if (!unwindingState.tracksBlockSpecificDrops()) continue;
                BlockPos position = ((IMixinLocation)((Object)((BlockSnapshot)transaction.getOriginal()).getLocation().get())).getBlockPos();
                postContext.getBlockDropSupplier().ifPresentAndNotEmpty(map -> {
                    if (map.containsKey((Object)position)) {
                        map.get((Object)position).clear();
                    }
                });
            }
            invalidTransactions.clear();
        }
        GeneralPhase.performPostBlockAdditions(postContext, postEvent.getTransactions(), unwindingState, unwinding);
    }

    private static void performPostBlockAdditions(PhaseContext postContext, List<Transaction<BlockSnapshot>> transactions, IPhaseState unwindingState, PhaseContext unwindingPhaseContext) {
        SpongeProxyBlockAccess proxyBlockAccess = new SpongeProxyBlockAccess(transactions);
        CapturedMultiMapSupplier<BlockPos, ItemDropData> capturedBlockDrops = postContext.getBlockDropSupplier();
        CapturedMultiMapSupplier<BlockPos, EntityItem> capturedBlockItemEntityDrops = postContext.getBlockItemDropSupplier();
        for (Transaction<BlockSnapshot> transaction : transactions) {
            if (!transaction.isValid()) continue;
            if (transaction.getCustom().isPresent()) {
                transaction.getFinal().restore(true, BlockChangeFlag.ALL);
            }
            SpongeBlockSnapshot oldBlockSnapshot = (SpongeBlockSnapshot)transaction.getOriginal();
            SpongeBlockSnapshot newBlockSnapshot = (SpongeBlockSnapshot)transaction.getFinal();
            Location<World> worldLocation = oldBlockSnapshot.getLocation().get();
            IMixinWorldServer mixinWorldServer = (IMixinWorldServer)((Object)worldLocation.getExtent());
            BlockPos pos = ((IMixinLocation)((Object)worldLocation)).getBlockPos();
            capturedBlockDrops.ifPresentAndNotEmpty(map -> TrackingUtil.spawnItemDataForBlockDrops(map.containsKey((Object)pos) ? map.get((Object)pos) : Collections.emptyList(), newBlockSnapshot, unwindingPhaseContext, unwindingState));
            capturedBlockItemEntityDrops.ifPresentAndNotEmpty(map -> TrackingUtil.spawnItemEntitiesForBlockDrops(map.containsKey((Object)pos) ? map.get((Object)pos) : Collections.emptyList(), newBlockSnapshot, unwindingPhaseContext, unwindingState));
            WorldServer worldServer = mixinWorldServer.asMinecraftWorld();
            SpongeHooks.logBlockAction((net.minecraft.world.World)worldServer, oldBlockSnapshot.blockChange, transaction);
            BlockChangeFlag changeFlag = oldBlockSnapshot.getChangeFlag();
            int updateFlag = oldBlockSnapshot.getUpdateFlag();
            IBlockState originalState = (IBlockState)oldBlockSnapshot.getState();
            IBlockState newState = (IBlockState)newBlockSnapshot.getState();
            CapturedSupplier<BlockSnapshot> capturedBlockSupplier = postContext.getCapturedBlockSupplier();
            if (changeFlag.performBlockPhysics() && originalState.func_177230_c() != newState.func_177230_c() && !SpongeImplHooks.hasBlockTileEntity(newState.func_177230_c(), newState)) {
                newState.func_177230_c().func_176213_c((net.minecraft.world.World)worldServer, pos, newState);
                postContext.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {});
                capturedBlockSupplier.ifPresentAndNotEmpty(blocks -> {
                    ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>((Collection<BlockSnapshot>)blocks);
                    blocks.clear();
                    GeneralPhase.processBlockTransactionListsPost(postContext, blockSnapshots, unwindingState, unwindingPhaseContext);
                });
            }
            proxyBlockAccess.proceed();
            unwindingState.handleBlockChangeWithUser(oldBlockSnapshot.blockChange, transaction, unwindingPhaseContext);
            if ((updateFlag & 2) != 0) {
                worldServer.func_184138_a(pos, originalState, newState, updateFlag);
            }
            if (changeFlag.updateNeighbors()) {
                mixinWorldServer.spongeNotifyNeighborsPostBlockChange(pos, originalState, newState, oldBlockSnapshot.getUpdateFlag());
            } else if ((updateFlag & 0x10) == 0) {
                worldServer.func_190522_c(pos, newState.func_177230_c());
            }
            capturedBlockSupplier.ifPresentAndNotEmpty(blocks -> {
                ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>((Collection<BlockSnapshot>)blocks);
                blocks.clear();
                GeneralPhase.processBlockTransactionListsPost(postContext, blockSnapshots, unwindingState, unwindingPhaseContext);
            });
        }
    }

    @Override
    public boolean ignoresBlockUpdateTick(PhaseData phaseData) {
        return phaseData.state == Post.UNWINDING;
    }

    @Override
    public boolean ignoresBlockEvent(IPhaseState phaseState) {
        return false;
    }

    @Override
    public boolean alreadyCapturingEntitySpawns(IPhaseState state) {
        return state == Post.UNWINDING || state == State.EXPLOSION;
    }

    @Override
    public boolean alreadyCapturingEntityTicks(IPhaseState state) {
        return state == Post.UNWINDING;
    }

    @Override
    public boolean alreadyCapturingTileTicks(IPhaseState state) {
        return state == Post.UNWINDING;
    }

    @Override
    public boolean alreadyCapturingItemSpawns(IPhaseState currentState) {
        return currentState == Post.UNWINDING || currentState == State.EXPLOSION;
    }

    @Override
    public boolean ignoresItemPreMerging(IPhaseState currentState) {
        return currentState == State.COMMAND || currentState == State.COMPLETE || super.ignoresItemPreMerging(currentState);
    }

    @Override
    public boolean requiresBlockCapturing(IPhaseState currentState) {
        return currentState != State.COMPLETE;
    }

    @Override
    public void associateNeighborStateNotifier(IPhaseState state, PhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        if (state == Post.UNWINDING) {
            IPhaseState unwindingState = context.getRequiredExtra("UnwindingState", IPhaseState.class);
            PhaseContext unwindingContext = context.getRequiredExtra("UnwindingContext", PhaseContext.class);
            unwindingState.getPhase().associateNeighborStateNotifier(unwindingState, unwindingContext, sourcePos, block, notifyPos, minecraftWorld, notifier);
        } else if (state == State.COMMAND) {
            context.getSource(Player.class).ifPresent(player -> ((IMixinChunk)minecraftWorld.func_175726_f(notifyPos)).setBlockNotifier(notifyPos, player.getUniqueId()));
        }
    }

    @Override
    public boolean ignoresScheduledUpdates(IPhaseState phaseState) {
        return phaseState == Post.UNWINDING;
    }

    @Override
    public boolean spawnEntityOrCapture(IPhaseState phaseState, PhaseContext context, Entity entity, int chunkX, int chunkZ) {
        return ((GeneralState)phaseState).spawnEntityOrCapture(context, entity, chunkX, chunkZ);
    }

    @Override
    public void appendContextPreExplosion(PhaseContext phaseContext, PhaseData currentPhaseData) {
        if (currentPhaseData.state == Post.UNWINDING) {
            ((PostState)currentPhaseData.state).appendContextPreExplosion(phaseContext, currentPhaseData);
            return;
        }
        super.appendContextPreExplosion(phaseContext, currentPhaseData);
    }

    private static final class Holder {
        static final GeneralPhase INSTANCE = new GeneralPhase();

        private Holder() {
        }
    }

    public static final class Post {
        public static final IPhaseState UNWINDING = new PostState();

        private Post() {
        }
    }

    public static final class State {
        public static final IPhaseState COMMAND = new CommandState();
        public static final IPhaseState EXPLOSION = new ExplosionState();
        public static final IPhaseState COMPLETE = new CompletePhase();
        public static final IPhaseState TILE_ENTITY_UNLOAD = new TileEntityUnloadState();
        public static final IPhaseState WORLD_UNLOAD = new WorldUnload();

        private State() {
        }
    }
}

