/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.generation;

import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.generation.GeneralGenerationPhaseState;
import org.spongepowered.common.event.tracking.phase.generation.PopulatorGenerationPhaseState;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public final class GenerationPhase
extends TrackingPhase {
    public static GenerationPhase getInstance() {
        return Holder.INSTANCE;
    }

    private GenerationPhase() {
    }

    @Override
    public void unwind(IPhaseState state, PhaseContext phaseContext) {
        ((GeneralGenerationPhaseState)state).unwind(phaseContext);
    }

    @Override
    public boolean requiresBlockCapturing(IPhaseState currentState) {
        return false;
    }

    @Override
    public boolean ignoresBlockEvent(IPhaseState phaseState) {
        return true;
    }

    @Override
    public boolean alreadyCapturingItemSpawns(IPhaseState currentState) {
        return true;
    }

    @Override
    public boolean ignoresBlockUpdateTick(PhaseData phaseData) {
        return phaseData.state != State.WORLD_SPAWNER_SPAWNING;
    }

    @Override
    public void appendNotifierPreBlockTick(IMixinWorldServer mixinWorld, BlockPos pos, IPhaseState currentState, PhaseContext context, PhaseContext newContext) {
    }

    @Override
    public boolean spawnEntityOrCapture(IPhaseState phaseState, PhaseContext context, Entity entity, int chunkX, int chunkZ) {
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        SpawnEntityEvent.Spawner event = SpongeEventFactory.createSpawnEntityEventSpawner(Sponge.getCauseStackManager().getCurrentCause(), entities);
        SpongeImpl.postEvent(event);
        if (!event.isCancelled() && event.getEntities().size() > 0) {
            for (Entity item : event.getEntities()) {
                ((IMixinWorldServer)((Object)item.getWorld())).forceSpawnEntity(item);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorldGeneration(IPhaseState state) {
        return true;
    }

    private static final class Holder {
        static final GenerationPhase INSTANCE = new GenerationPhase();

        private Holder() {
        }
    }

    public static final class State {
        public static final IPhaseState CHUNK_LOADING = new GeneralGenerationPhaseState("CHUNK_LOADING").bake();
        public static final IPhaseState WORLD_SPAWNER_SPAWNING = new GeneralGenerationPhaseState("WORLD_SPAWNER_SPAWNING").bake();
        public static final IPhaseState POPULATOR_RUNNING = new PopulatorGenerationPhaseState("POPULATOR_RUNNING");
        public static final IPhaseState TERRAIN_GENERATION = new GeneralGenerationPhaseState("TERRAIN_GENERATION");

        static {
            ((GeneralGenerationPhaseState)POPULATOR_RUNNING).addCompatibleState(BlockPhase.State.BLOCK_DECAY).addCompatibleState(BlockPhase.State.BLOCK_DROP_ITEMS).addCompatibleState(BlockPhase.State.RESTORING_BLOCKS).addCompatibleState(WORLD_SPAWNER_SPAWNING).addCompatibleState(GeneralPhase.Post.UNWINDING).addCompatibleState(POPULATOR_RUNNING).bake();
            ((GeneralGenerationPhaseState)TERRAIN_GENERATION).addCompatibleState(BlockPhase.State.BLOCK_DECAY).addCompatibleState(BlockPhase.State.BLOCK_DROP_ITEMS).addCompatibleState(BlockPhase.State.RESTORING_BLOCKS).addCompatibleState(POPULATOR_RUNNING).addCompatibleState(WORLD_SPAWNER_SPAWNING).addCompatibleState(GeneralPhase.Post.UNWINDING).bake();
        }
    }
}

