/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.EnumHand;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;

public final class PacketPhaseUtil {
    public static void handleSlotRestore(EntityPlayerMP player, Container openContainer, List<SlotTransaction> slotTransactions, boolean eventCancelled) {
        for (SlotTransaction slotTransaction : slotTransactions) {
            if (!slotTransaction.getCustom().isPresent() && slotTransaction.isValid() && !eventCancelled) continue;
            SlotAdapter slot = (SlotAdapter)slotTransaction.getSlot();
            int slotNumber = slot.slotNumber;
            ItemStackSnapshot snapshot = eventCancelled || !slotTransaction.isValid() ? (ItemStackSnapshot)slotTransaction.getOriginal() : (ItemStackSnapshot)slotTransaction.getCustom().get();
            net.minecraft.item.ItemStack originalStack = ItemStackUtil.fromSnapshotToNative(snapshot);
            Slot nmsSlot = openContainer.func_75139_a(slotNumber);
            if (nmsSlot == null) continue;
            nmsSlot.func_75215_d(originalStack);
        }
        openContainer.func_75142_b();
        if (eventCancelled && player.field_71070_bA == openContainer) {
            player.func_71120_a(openContainer);
        }
    }

    public static void handleCustomCursor(EntityPlayerMP player, ItemStackSnapshot customCursor) {
        net.minecraft.item.ItemStack cursor = ItemStackUtil.fromSnapshotToNative(customCursor);
        player.field_71071_by.func_70437_b(cursor);
        player.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-1, -1, cursor));
    }

    public static void validateCapturedTransactions(int slotId, Container openContainer, List<SlotTransaction> capturedTransactions) {
        Slot slot;
        if (capturedTransactions.size() == 0 && slotId >= 0 && slotId < openContainer.field_75151_b.size() && (slot = openContainer.func_75139_a(slotId)) != null) {
            ItemStackSnapshot snapshot = slot.func_75216_d() ? ((ItemStack)slot.func_75211_c()).createSnapshot() : ItemStackSnapshot.NONE;
            SlotTransaction slotTransaction = new SlotTransaction(ContainerUtil.getSlotAdapter(openContainer, slotId), snapshot, snapshot);
            capturedTransactions.add(slotTransaction);
        }
    }

    public static void handlePlayerSlotRestore(EntityPlayerMP player, net.minecraft.item.ItemStack itemStack, EnumHand hand) {
        if (itemStack.func_190926_b() || itemStack == ItemTypeRegistryModule.NONE) {
            return;
        }
        player.field_71137_h = false;
        int slotId = 0;
        if (hand == EnumHand.OFF_HAND) {
            player.field_71071_by.field_184439_c.set(0, (Object)itemStack);
            slotId = player.field_71071_by.field_70462_a.size() + InventoryPlayer.func_70451_h();
        } else {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)itemStack);
            Slot slot = player.field_71070_bA.func_75147_a((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c);
            slotId = slot.field_75222_d;
        }
        player.field_71070_bA.func_75142_b();
        player.field_71137_h = false;
        player.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(player.field_71070_bA.field_75152_c, slotId, itemStack));
    }

    public static boolean allTransactionsInvalid(List<SlotTransaction> slotTransactions) {
        if (slotTransactions.size() == 0) {
            return false;
        }
        for (SlotTransaction slotTransaction : slotTransactions) {
            if (!slotTransaction.isValid()) continue;
            return false;
        }
        return true;
    }
}

