/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhaseState;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

final class CustomExplosionState
extends PluginPhaseState {
    CustomExplosionState() {
    }

    @Override
    public boolean canSwitchTo(IPhaseState state) {
        return true;
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }

    @Override
    public boolean tracksBlockSpecificDrops() {
        return true;
    }

    @Override
    void processPostTick(PhaseContext context) {
        Explosion explosion = context.getRequiredExtra("Explosion", Explosion.class);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.TNT_IGNITE);
            Sponge.getCauseStackManager().pushCause(explosion);
            if (context.getNotifier().isPresent()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, context.getNotifier().get());
            }
            if (context.getOwner().isPresent()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, context.getOwner().get());
            }
            context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> this.processBlockCaptures((List<BlockSnapshot>)blocks, explosion, Sponge.getCauseStackManager().getCurrentCause(), context));
            context.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
                User user = context.getNotifier().orElseGet(() -> context.getOwner().orElse(null));
                TrackingUtil.splitAndSpawnEntities(entities, entity -> entity.setCreator(user.getUniqueId()));
            });
        }
    }

    private void processBlockCaptures(List<BlockSnapshot> snapshots, Explosion explosion, Cause cause, PhaseContext context) {
        if (snapshots.isEmpty()) {
            return;
        }
        ImmutableList[] transactionArrays = new ImmutableList[5];
        ImmutableList.Builder[] transactionBuilders = new ImmutableList.Builder[5];
        for (int i = 0; i < 5; ++i) {
            transactionBuilders[i] = new ImmutableList.Builder();
        }
        ArrayList<ChangeBlockEvent> blockEvents = new ArrayList<ChangeBlockEvent>();
        for (BlockSnapshot snapshot : snapshots) {
            TrackingUtil.TRANSACTION_PROCESSOR.apply(transactionBuilders).accept(TrackingUtil.TRANSACTION_CREATION.apply(snapshot));
        }
        for (int i = 0; i < 5; ++i) {
            transactionArrays[i] = transactionBuilders[i].build();
        }
        ChangeBlockEvent[] mainEvents = new ChangeBlockEvent[BlockChange.values().length];
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (context.getNotifier().isPresent()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, context.getNotifier().get());
            }
            if (context.getOwner().isPresent()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, context.getOwner().get());
            }
            try {
                this.getPhase().associateAdditionalCauses(this, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TrackingUtil.iterateChangeBlockEvents(transactionArrays, blockEvents, mainEvents);
            for (BlockChange blockChange : BlockChange.values()) {
                ChangeBlockEvent mainEvent = mainEvents[blockChange.ordinal()];
                if (mainEvent == null) continue;
                Sponge.getCauseStackManager().pushCause(mainEvent);
            }
            ImmutableList transactions = transactionArrays[4];
            ExplosionEvent.Post postEvent = SpongeEventFactory.createExplosionEventPost(cause, explosion, (List)transactions);
            if (postEvent == null) {
                return;
            }
            SpongeImpl.postEvent(postEvent);
            ArrayList<Transaction> invalid = new ArrayList<Transaction>();
            boolean noCancelledTransactions = true;
            for (ChangeBlockEvent changeBlockEvent : blockEvents) {
                if (!changeBlockEvent.isCancelled()) continue;
                noCancelledTransactions = false;
                for (Transaction transaction : Lists.reverse(changeBlockEvent.getTransactions())) {
                    transaction.setValid(false);
                }
            }
            if (postEvent.isCancelled()) {
                noCancelledTransactions = false;
                for (Transaction transaction : postEvent.getTransactions()) {
                    transaction.setValid(false);
                }
            }
            for (Transaction transaction : postEvent.getTransactions()) {
                if (transaction.isValid()) continue;
                invalid.add(transaction);
                context.getBlockItemDropSupplier().ifPresentAndNotEmpty(map -> {
                    BlockPos blockPos = ((IMixinLocation)((Object)((BlockSnapshot)transaction.getOriginal()).getLocation().get())).getBlockPos();
                    map.get((Object)blockPos).clear();
                });
            }
            if (!invalid.isEmpty()) {
                noCancelledTransactions = false;
                for (Transaction transaction : Lists.reverse(invalid)) {
                    ((BlockSnapshot)transaction.getOriginal()).restore(true, BlockChangeFlag.NONE);
                    BlockPos position = ((IMixinLocation)((Object)((BlockSnapshot)transaction.getOriginal()).getLocation().get())).getBlockPos();
                    context.getBlockDropSupplier().ifPresentAndNotEmpty(map -> {
                        if (map.containsKey((Object)position)) {
                            map.get((Object)position).clear();
                        }
                    });
                }
            }
            TrackingUtil.performBlockAdditions(postEvent.getTransactions(), this, context, noCancelledTransactions);
        }
    }

    @Override
    public boolean shouldCaptureBlockChangeOrSkip(PhaseContext phaseContext, BlockPos pos) {
        Vector3i blockPos = VecHelper.toVector3i(pos);
        for (BlockSnapshot capturedSnapshot : phaseContext.getCapturedBlocks()) {
            if (!capturedSnapshot.getPosition().equals(blockPos)) continue;
            return true;
        }
        return false;
    }
}

