/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

class BlockTickPhaseState
extends LocationBasedTickPhaseState {
    private final String name;

    BlockTickPhaseState(String name) {
        this.name = name;
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
    }

    @Override
    Location<World> getLocationSourceFromContext(PhaseContext context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context)).getLocation();
    }

    @Override
    public void processPostTick(PhaseContext context) {
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(locatableBlock);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
            User entityCreator = context.getNotifier().orElseGet(() -> context.getOwner().orElse(null));
            context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, context));
            context.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
                ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem entity : items) {
                    capturedEntities.add(EntityUtil.fromNative((Entity)entity));
                }
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), capturedEntities);
                SpongeImpl.postEvent(spawnEntityEvent);
                for (org.spongepowered.api.entity.Entity entity : spawnEntityEvent.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            });
        }
    }

    @Override
    public void appendExplosionContext(PhaseContext explosionContext, PhaseContext context) {
        context.getOwner().ifPresent(explosionContext::owner);
        context.getNotifier().ifPresent(explosionContext::notifier);
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        explosionContext.source(locatableBlock);
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        Optional<User> owner = context.getOwner();
        Optional<User> notifier = context.getNotifier();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(locatableBlock);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.EXPERIENCE);
            if (notifier.isPresent()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, notifier.get());
            }
            if (owner.isPresent()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, owner.get());
            }
            if (entity instanceof EntityXPOrb) {
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
                entities.add(entity);
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity anEntity : event.getEntities()) {
                        if (entityCreator != null) {
                            EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            ArrayList<org.spongepowered.api.entity.Entity> nonExpEntities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            nonExpEntities.add(entity);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.BLOCK_SPAWNING);
            SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), nonExpEntities);
            SpongeImpl.postEvent(spawnEntityEvent);
            if (!spawnEntityEvent.isCancelled()) {
                for (org.spongepowered.api.entity.Entity anEntity : spawnEntityEvent.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void postTrackBlock(BlockSnapshot snapshot, CauseTracker tracker, PhaseContext context) {
        if (context.shouldProcessImmediately()) {
            TrackingUtil.processBlockCaptures(context.getCapturedBlocks(), this, context);
            context.getCapturedBlockSupplier().get().remove(snapshot);
        }
    }

    public String toString() {
        return this.name;
    }
}

