/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.CombatEntry;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.Ageable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class EntityTickPhaseState
extends TickPhaseState {
    EntityTickPhaseState() {
    }

    @Override
    public void processPostTick(PhaseContext phaseContext) {
        org.spongepowered.api.entity.Entity tickingEntity = phaseContext.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", phaseContext));
        Optional<User> creator = phaseContext.getOwner();
        Optional<User> notifier = phaseContext.getNotifier();
        User entityCreator = notifier.orElseGet(() -> creator.orElse(null));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(tickingEntity);
            phaseContext.addNotifierAndOwnerToCauseStack();
            phaseContext.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
                SpawnEntityEvent event;
                ArrayList<org.spongepowered.api.entity.Entity> experience = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
                ArrayList<org.spongepowered.api.entity.Entity> nonExp = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
                ArrayList<org.spongepowered.api.entity.Entity> breeding = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
                ArrayList<org.spongepowered.api.entity.Entity> projectile = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
                for (org.spongepowered.api.entity.Entity entity : entities) {
                    if (entity instanceof EntityXPOrb) {
                        experience.add(entity);
                        continue;
                    }
                    if (tickingEntity instanceof Ageable && tickingEntity.getClass() == entity.getClass()) {
                        breeding.add(entity);
                        continue;
                    }
                    if (entity instanceof Projectile) {
                        projectile.add(entity);
                        continue;
                    }
                    nonExp.add(entity);
                }
                if (!experience.isEmpty()) {
                    CombatEntry entry;
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.EXPERIENCE);
                    if (EntityUtil.isEntityDead(tickingEntity) && tickingEntity instanceof EntityLivingBase && (entry = ((EntityLivingBase)tickingEntity).func_110142_aN().func_94544_f()) != null && entry.field_94569_a != null) {
                        Sponge.getCauseStackManager().addContext(EventContextKeys.LAST_DAMAGE_SOURCE, (DamageSource)entry.field_94569_a);
                    }
                    if (!SpongeImpl.postEvent(event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), experience))) {
                        for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                            if (entityCreator != null) {
                                EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                            }
                            EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                        }
                    }
                    Sponge.getCauseStackManager().removeContext(EventContextKeys.LAST_DAMAGE_SOURCE);
                }
                if (!breeding.isEmpty()) {
                    EntityPlayerMP playerInLove;
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.BREEDING);
                    if (tickingEntity instanceof EntityAnimal && (playerInLove = ((EntityAnimal)tickingEntity).func_191993_do()) != null) {
                        Sponge.getCauseStackManager().addContext(EventContextKeys.PLAYER, (Player)playerInLove);
                    }
                    if (!SpongeImpl.postEvent(event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), breeding))) {
                        for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                            if (entityCreator != null) {
                                EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                            }
                            EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                        }
                    }
                    Sponge.getCauseStackManager().removeContext(EventContextKeys.PLAYER);
                }
                if (!projectile.isEmpty()) {
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PROJECTILE);
                    event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), projectile);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                            if (entityCreator != null) {
                                entity.setCreator(entityCreator.getUniqueId());
                            }
                            EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                        }
                    }
                }
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PASSIVE);
                event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), nonExp);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                        if (entityCreator != null) {
                            entity.setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
            phaseContext.getCapturedItemsSupplier().ifPresentAndNotEmpty(entities -> {
                ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem entity : entities) {
                    capturedEntities.add(EntityUtil.fromNative((Entity)entity));
                }
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
                DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), capturedEntities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                        if (entityCreator != null) {
                            EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
            phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
            phaseContext.getBlockItemDropSupplier().ifPresentAndNotEmpty(map -> {
                List<BlockSnapshot> capturedBlocks = phaseContext.getCapturedBlocks();
                for (BlockSnapshot snapshot : capturedBlocks) {
                    BlockPos blockPos = ((IMixinLocation)((Object)snapshot.getLocation().get())).getBlockPos();
                    List entityItems = map.get((Object)blockPos);
                    if (entityItems.isEmpty()) continue;
                    Sponge.getCauseStackManager().pushCause(snapshot);
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
                    List items = entityItems.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                    DropItemEvent.Destruct event = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), items);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                            creator.ifPresent(user -> entity.setCreator(user.getUniqueId()));
                            EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                        }
                    }
                    Sponge.getCauseStackManager().popCause();
                }
            });
            phaseContext.getCapturedItemStackSupplier().ifPresentAndNotEmpty(drops -> {
                List items = drops.stream().map(drop -> drop.create(EntityUtil.getMinecraftWorld(tickingEntity))).collect(Collectors.toList());
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
                List entities = items;
                if (!entities.isEmpty()) {
                    DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        for (org.spongepowered.api.entity.Entity droppedItem : event.getEntities()) {
                            EntityUtil.getMixinWorld(droppedItem).forceSpawnEntity(droppedItem);
                        }
                    }
                }
            });
            this.fireMovementEvents(EntityUtil.toNative(tickingEntity));
        }
    }

    private void fireMovementEvents(Entity entity) {
        if (entity.field_70128_L || entity instanceof IProjectile || entity instanceof EntityItem) {
            return;
        }
        org.spongepowered.api.entity.Entity spongeEntity = (org.spongepowered.api.entity.Entity)entity;
        if (entity.field_70142_S != entity.field_70165_t || entity.field_70137_T != entity.field_70163_u || entity.field_70136_U != entity.field_70161_v || entity.field_70125_A != entity.field_70127_C || entity.field_70177_z != entity.field_70126_B) {
            double currentPosX = entity.field_70165_t;
            double currentPosY = entity.field_70163_u;
            double currentPosZ = entity.field_70161_v;
            Vector3d oldPositionVector = new Vector3d(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U);
            Vector3d currentPositionVector = new Vector3d(currentPosX, currentPosY, currentPosZ);
            Vector3d oldRotationVector = new Vector3d(entity.field_70127_C, entity.field_70126_B, 0.0f);
            Vector3d currentRotationVector = new Vector3d(entity.field_70125_A, entity.field_70177_z, 0.0f);
            Transform<World> oldTransform = new Transform<World>(spongeEntity.getWorld(), oldPositionVector, oldRotationVector, spongeEntity.getScale());
            Transform<World> newTransform = new Transform<World>(spongeEntity.getWorld(), currentPositionVector, currentRotationVector, spongeEntity.getScale());
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), oldTransform, newTransform, spongeEntity);
            if (SpongeImpl.postEvent(event)) {
                entity.field_70165_t = entity.field_70142_S;
                entity.field_70163_u = entity.field_70137_T;
                entity.field_70161_v = entity.field_70136_U;
                entity.field_70125_A = entity.field_70127_C;
                entity.field_70177_z = entity.field_70126_B;
            } else {
                Vector3d newPosition = event.getToTransform().getPosition();
                if (!newPosition.equals(currentPositionVector)) {
                    entity.field_70165_t = newPosition.getX();
                    entity.field_70163_u = newPosition.getY();
                    entity.field_70161_v = newPosition.getZ();
                }
                if (!event.getToTransform().getRotation().equals(currentRotationVector)) {
                    entity.field_70125_A = (float)currentRotationVector.getX();
                    entity.field_70177_z = (float)currentRotationVector.getY();
                }
            }
        }
    }

    @Override
    public void handleBlockChangeWithUser(@Nullable BlockChange blockChange, Transaction<BlockSnapshot> transaction, PhaseContext context) {
        if (blockChange == BlockChange.BREAK) {
            org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).get();
            BlockPos blockPos = VecHelper.toBlockPos(transaction.getOriginal().getPosition());
            for (EntityHanging entityHanging : EntityUtil.findHangingEntities(EntityUtil.getMinecraftWorld(tickingEntity), blockPos)) {
                if (!(entityHanging instanceof EntityItemFrame)) continue;
                EntityItemFrame frame = (EntityItemFrame)entityHanging;
                if (tickingEntity != null && !frame.field_70128_L) {
                    frame.func_146065_b(EntityUtil.toNative(tickingEntity), true);
                }
                frame.func_70106_y();
            }
        }
    }

    @Override
    public void processPostSpawns(PhaseContext phaseContext, ArrayList<org.spongepowered.api.entity.Entity> entities) {
        super.processPostSpawns(phaseContext, entities);
    }

    @Override
    public void appendExplosionContext(PhaseContext explosionContext, PhaseContext context) {
        context.getOwner().ifPresent(explosionContext::owner);
        context.getNotifier().ifPresent(explosionContext::notifier);
        org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking entity!", context));
        Sponge.getCauseStackManager().pushCause(tickingEntity);
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        Optional<User> creator = context.getOwner();
        Optional<User> notifier = context.getNotifier();
        User entityCreator = notifier.orElseGet(() -> creator.orElse(null));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            context.addNotifierAndOwnerToCauseStack();
            Sponge.getCauseStackManager().pushCause(tickingEntity);
            if (entity instanceof EntityXPOrb) {
                CombatEntry entry;
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.EXPERIENCE);
                if (EntityUtil.isEntityDead(tickingEntity) && tickingEntity instanceof EntityLivingBase && (entry = ((EntityLivingBase)tickingEntity).func_110142_aN().func_94544_f()) != null && entry.field_94569_a != null) {
                    Sponge.getCauseStackManager().addContext(EventContextKeys.LAST_DAMAGE_SOURCE, (DamageSource)entry.field_94569_a);
                }
                ArrayList<org.spongepowered.api.entity.Entity> experience = new ArrayList<org.spongepowered.api.entity.Entity>(1);
                experience.add(entity);
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), experience);
                if (!SpongeImpl.postEvent(event)) {
                    for (org.spongepowered.api.entity.Entity anEntity : event.getEntities()) {
                        if (entityCreator != null) {
                            EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (tickingEntity instanceof Ageable && tickingEntity.getClass() == entity.getClass()) {
                EntityPlayerMP playerInLove;
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.BREEDING);
                if (tickingEntity instanceof EntityAnimal && (playerInLove = ((EntityAnimal)tickingEntity).func_191993_do()) != null) {
                    Sponge.getCauseStackManager().addContext(EventContextKeys.PLAYER, (Player)playerInLove);
                }
                ArrayList<org.spongepowered.api.entity.Entity> breeding = new ArrayList<org.spongepowered.api.entity.Entity>(1);
                breeding.add(entity);
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), breeding);
                if (!SpongeImpl.postEvent(event)) {
                    for (org.spongepowered.api.entity.Entity anEntity : event.getEntities()) {
                        if (entityCreator != null) {
                            EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (entity instanceof Projectile) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PROJECTILE);
                ArrayList<org.spongepowered.api.entity.Entity> projectile = new ArrayList<org.spongepowered.api.entity.Entity>(1);
                projectile.add(entity);
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), projectile);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity anEntity : event.getEntities()) {
                        if (entityCreator != null) {
                            anEntity.setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            ArrayList<org.spongepowered.api.entity.Entity> nonExp = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            nonExp.add(entity);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PASSIVE);
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), nonExp);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity anEntity : event.getEntities()) {
                    if (entityCreator != null) {
                        anEntity.setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public String toString() {
        return "EntityTickPhase";
    }
}

