/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.tick.BlockEventTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.DimensionTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.NoCaptureBlockTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.PlayerTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.WeatherTickPhaseState;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public final class TickPhase
extends TrackingPhase {
    @Override
    public void unwind(IPhaseState state, PhaseContext context) {
        ((TickPhaseState)state).processPostTick(context);
    }

    public static TickPhase getInstance() {
        return Holder.INSTANCE;
    }

    private TickPhase() {
    }

    @Override
    public boolean spawnEntityOrCapture(IPhaseState phaseState, PhaseContext context, Entity entity, int chunkX, int chunkZ) {
        return ((TickPhaseState)phaseState).spawnEntityOrCapture(context, entity, chunkX, chunkZ);
    }

    @Override
    public void processPostEntitySpawns(IPhaseState unwindingState, PhaseContext phaseContext, ArrayList<Entity> entities) {
        ((TickPhaseState)unwindingState).processPostSpawns(phaseContext, entities);
    }

    @Override
    public boolean requiresBlockCapturing(IPhaseState currentState) {
        return currentState != Tick.NO_CAPTURE_BLOCK;
    }

    @Override
    public void addNotifierToBlockEvent(IPhaseState phaseState, PhaseContext context, IMixinWorldServer mixinWorld, BlockPos pos, IMixinBlockEventData blockEvent) {
    }

    @Override
    public void appendNotifierPreBlockTick(IMixinWorldServer mixinWorld, BlockPos pos, IPhaseState currentState, PhaseContext context, PhaseContext newContext) {
        if (currentState == Tick.BLOCK || currentState == Tick.RANDOM_BLOCK) {
            // empty if block
        }
    }

    @Override
    public void associateNeighborStateNotifier(IPhaseState state, PhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        ((TickPhaseState)state).associateNeighborBlockNotifier(context, sourcePos, block, notifyPos, minecraftWorld, notifier);
    }

    @Override
    public boolean isTicking(IPhaseState state) {
        return true;
    }

    @Override
    public boolean alreadyCapturingItemSpawns(IPhaseState currentState) {
        return currentState != Tick.NO_CAPTURE_BLOCK;
    }

    @Override
    public void appendContextPreExplosion(PhaseContext phaseContext, PhaseData currentPhaseData) {
        ((TickPhaseState)currentPhaseData.state).appendExplosionContext(phaseContext, currentPhaseData.context);
    }

    private static final class Holder {
        static final TickPhase INSTANCE = new TickPhase();

        private Holder() {
        }
    }

    public static final class Tick {
        public static final IPhaseState NO_CAPTURE_BLOCK = new NoCaptureBlockTickPhaseState("NoCaptureBlockTickPhase");
        public static final IPhaseState BLOCK = new BlockTickPhaseState("BlockTickPhase");
        public static final IPhaseState RANDOM_BLOCK = new BlockTickPhaseState("RandomBlockTickPhase");
        public static final IPhaseState ENTITY = new EntityTickPhaseState();
        public static final IPhaseState DIMENSION = new DimensionTickPhaseState();
        public static final IPhaseState TILE_ENTITY = new TileEntityTickPhaseState();
        public static final IPhaseState BLOCK_EVENT = new BlockEventTickPhaseState();
        public static final IPhaseState PLAYER = new PlayerTickPhaseState();
        public static final IPhaseState WEATHER = new WeatherTickPhaseState();

        private Tick() {
        }
    }
}

