/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class SlotCollectionIterator
implements Iterable<Slot> {
    private Inventory parent;
    private final Fabric<IInventory> inv;
    private final List<Slot> slots;

    public SlotCollectionIterator(Inventory parent, Fabric<IInventory> inv, Lens<IInventory, ItemStack> lens, SlotCollection slots) {
        this.parent = parent;
        this.inv = inv;
        this.slots = this.traverseSpanningTree(inv, lens, slots, (ImmutableList.Builder<Slot>)ImmutableList.builder()).build();
    }

    private ImmutableList.Builder<Slot> traverseSpanningTree(Fabric<IInventory> inv, Lens<IInventory, ItemStack> lens, SlotCollection slots, ImmutableList.Builder<Slot> list) {
        for (Lens<IInventory, ItemStack> child : lens.getSpanningChildren()) {
            if (child instanceof SlotLens) {
                list.add((Object)((SlotAdapter)child.getAdapter(inv, this.parent)));
                continue;
            }
            if (child.getSpanningChildren().size() <= 0) continue;
            this.traverseSpanningTree(inv, child, slots, list);
        }
        return list;
    }

    public Fabric<IInventory> getFabric() {
        return this.inv;
    }

    @Override
    public Iterator<Slot> iterator() {
        return this.slots.iterator();
    }
}

