/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl.slots;

import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.slot.FilteringSlot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.slots.FilteringSlotLens;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class FilteringSlotAdapter
extends SlotAdapter
implements FilteringSlot {
    protected final FilteringSlotLens<IInventory, net.minecraft.item.ItemStack> filteringSlot;

    public FilteringSlotAdapter(Fabric<IInventory> inventory, FilteringSlotLens<IInventory, net.minecraft.item.ItemStack> lens, Inventory parent) {
        super(inventory, (SlotLens<IInventory, net.minecraft.item.ItemStack>)lens, parent);
        this.filteringSlot = lens;
    }

    @Override
    public boolean isValidItem(ItemStack stack) {
        Predicate<ItemStack> filter = this.filteringSlot.getItemStackFilter();
        return filter == null ? true : filter.test(stack);
    }

    @Override
    public boolean isValidItem(ItemType type) {
        Predicate<ItemType> filter = this.filteringSlot.getItemTypeFilter();
        return filter == null ? true : filter.test(type);
    }

    @Override
    public InventoryTransactionResult offer(ItemStack stack) {
        boolean canOffer = this.isValidItem(stack);
        if (!canOffer) {
            InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE);
            result.reject(ItemStackUtil.cloneDefensive(stack));
            return result.build();
        }
        return super.offer(stack);
    }

    @Override
    public InventoryTransactionResult set(ItemStack stack) {
        boolean canSet = this.isValidItem(stack);
        if (!canSet) {
            InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE);
            result.reject(ItemStackUtil.cloneDefensive(stack));
            return result.build();
        }
        return super.set(stack);
    }
}

