/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.archetype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryProperty;

public class CompositeInventoryArchetype
implements InventoryArchetype {
    private final String id;
    private final String name;
    private final List<InventoryArchetype> types;
    private final Map<String, InventoryProperty<String, ?>> properties;
    @Nullable
    private ContainerProvider containerProvider;

    public CompositeInventoryArchetype(String id, String name, List<InventoryArchetype> types, Map<String, InventoryProperty<String, ?>> properties, @Nullable ContainerProvider containerProvider) {
        this.id = id;
        this.name = name;
        this.types = ImmutableList.copyOf(types);
        this.properties = ImmutableMap.copyOf(properties);
        this.containerProvider = containerProvider;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<InventoryArchetype> getChildArchetypes() {
        return this.types;
    }

    @Override
    public Optional<InventoryProperty<String, ?>> getProperty(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    @Override
    public <T extends InventoryProperty<String, ?>> Optional<T> getProperty(Class<T> type, String key) {
        InventoryProperty<String, ?> property = this.properties.get(key);
        if (property == null) {
            return Optional.empty();
        }
        if (type.isAssignableFrom(property.getClass())) {
            return Optional.of(property);
        }
        return Optional.empty();
    }

    @Override
    public Map<String, InventoryProperty<String, ?>> getProperties() {
        return this.properties;
    }

    @Nullable
    public ContainerProvider getContainerProvider() {
        return this.containerProvider;
    }

    public static interface ContainerProvider {
        public Container provide(IInventory var1, EntityPlayer var2);
    }
}

