/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableGrowthData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.world.Location;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeGrowthData;
import org.spongepowered.common.event.damage.MinecraftBlockDamageSource;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@Mixin(value={BlockCactus.class})
public abstract class MixinBlockCactus
extends MixinBlock {
    private static final String CACTUS_DAMAGE_FIELD = "Lnet/minecraft/util/DamageSource;CACTUS:Lnet/minecraft/util/DamageSource;";
    @Nullable
    private DamageSource originalCactus;

    @Inject(method={"onEntityCollidedWithBlock"}, at={@At(value="FIELD", target="Lnet/minecraft/util/DamageSource;CACTUS:Lnet/minecraft/util/DamageSource;", opcode=178)})
    public void preSetOnFire(World worldIn, BlockPos pos, IBlockState state, Entity entityIn, CallbackInfo callbackInfo) {
        if (!worldIn.field_72995_K) {
            this.originalCactus = DamageSource.field_76367_g;
            Location<org.spongepowered.api.world.World> location = new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            DamageSource.field_76367_g = new MinecraftBlockDamageSource("cactus", location).func_76361_j();
        }
    }

    @Inject(method={"onEntityCollidedWithBlock"}, at={@At(value="FIELD", target="Lnet/minecraft/util/DamageSource;CACTUS:Lnet/minecraft/util/DamageSource;", opcode=178, shift=At.Shift.AFTER)})
    public void postSetOnFire(World worldIn, BlockPos pos, IBlockState state, Entity entityIn, CallbackInfo callbackInfo) {
        if (!worldIn.field_72995_K) {
            if (this.originalCactus == null) {
                SpongeImpl.getLogger().error("Original cactus is null!");
                Thread.dumpStack();
            }
            DamageSource.field_76367_g = this.originalCactus;
        }
    }

    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getGrowthData(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableGrowthData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableGrowthData) {
            int growth = (Integer)((ImmutableGrowthData)manipulator).growthStage().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockCactus.field_176587_a, (Comparable)Integer.valueOf(growth)));
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.GROWTH_STAGE)) {
            int growth = (Integer)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockCactus.field_176587_a, (Comparable)Integer.valueOf(growth)));
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableGrowthData getGrowthData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeGrowthData.class, blockState.func_177229_b((IProperty)BlockCactus.field_176587_a), 0, 15);
    }
}

