/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.block.BlockUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

@Mixin(value={BlockDynamicLiquid.class})
public abstract class MixinBlockDynamicLiquid {
    @Inject(method={"canFlowInto"}, at={@At(value="HEAD")}, cancellable=true)
    public void onCanFlowInto(World worldIn, BlockPos pos, IBlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (!worldIn.field_72995_K && SpongeCommonEventFactory.callChangeBlockEventPre((IMixinWorldServer)worldIn, pos).isCancelled()) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method={"updateTick"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUpdateTick(World worldIn, BlockPos pos, IBlockState state, Random rand, CallbackInfo ci) {
        if (!worldIn.field_72995_K && SpongeCommonEventFactory.callChangeBlockEventPre((IMixinWorldServer)worldIn, pos).isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"updateTick"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z")})
    private void beforeSetBlockState(World worldIn, BlockPos pos, IBlockState state, Random rand, CallbackInfo ci) {
        BlockPos sourcePos = pos.func_177984_a();
        Location<org.spongepowered.api.world.World> loc = new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldIn, sourcePos.func_177958_n(), sourcePos.func_177956_o(), sourcePos.func_177952_p());
        LocatableBlock source = LocatableBlock.builder().location(loc).build();
        IBlockState newState = Blocks.field_150348_b.func_176223_P();
        ChangeBlockEvent.Modify event = SpongeCommonEventFactory.callChangeBlockEventModifyLiquidMix(worldIn, pos, newState, source);
        Transaction<BlockSnapshot> transaction = event.getTransactions().get(0);
        if (event.isCancelled() || !transaction.isValid()) {
            ci.cancel();
            return;
        }
        if (!worldIn.func_175656_a(pos, BlockUtil.toNative(transaction.getFinal().getState()))) {
            ci.cancel();
        }
    }

    @Inject(method={"tryFlowInto"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/block/state/IBlockState;getMaterial()Lnet/minecraft/block/material/Material;")})
    private void afterCanFlowInto(World worldIn, BlockPos pos, IBlockState state, int level, CallbackInfo ci) {
        IBlockState defaultState = ((Block)this).func_176223_P();
        if (state.func_185904_a() != Material.field_151579_a && state.func_185904_a() != defaultState.func_185904_a()) {
            IBlockState newState = defaultState.func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level));
            ChangeBlockEvent.Break event = SpongeCommonEventFactory.callChangeBlockEventModifyLiquidBreak(worldIn, pos, newState, 3);
            Transaction<BlockSnapshot> transaction = event.getTransactions().get(0);
            if (event.isCancelled() || !transaction.isValid()) {
                ci.cancel();
                return;
            }
            if (transaction.getDefault() != transaction.getFinal()) {
                worldIn.func_175656_a(pos, BlockUtil.toNative(transaction.getFinal().getState()));
                ci.cancel();
            }
        }
    }
}

