/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityCommandBlock;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeInternalListeners;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.interfaces.IMixinCommandSource;
import org.spongepowered.common.interfaces.IMixinSubject;
import org.spongepowered.common.service.permission.SubjectSettingCallback;

@NonnullByDefault
@Mixin(value={EntityPlayerMP.class, TileEntityCommandBlock.class, EntityMinecartCommandBlock.class, MinecraftServer.class, RConConsoleSource.class, SpongeUser.class}, targets={"net/minecraft/tileentity/TileEntitySign$1"})
public abstract class MixinSubject
implements Subject,
IMixinCommandSource,
IMixinSubject {
    @Nullable
    private SubjectReference thisSubject;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    public void subjectConstructor(CallbackInfo ci) {
        if (SpongeImpl.isInitialized()) {
            SpongeInternalListeners.getInstance().registerExpirableServiceCallback(PermissionService.class, new SubjectSettingCallback(this));
        }
    }

    @Override
    public void setSubject(SubjectReference subj) {
        this.thisSubject = subj;
    }

    @Override
    public CompletableFuture<Subject> loadInternalSubject() {
        return this.asSubjectReference().resolve();
    }

    @Nullable
    private Subject resolveNullable() {
        Optional<PermissionService> serv;
        if (this.thisSubject == null && (serv = SpongeImpl.getGame().getServiceManager().provide(PermissionService.class)).isPresent()) {
            new SubjectSettingCallback(this).test(serv.get());
        }
        return this.thisSubject == null ? null : this.thisSubject.resolve().join();
    }

    private Subject resolve() {
        Subject ret = this.resolveNullable();
        if (ret == null) {
            throw new IllegalStateException("No subject reference present for user " + this);
        }
        return ret;
    }

    @Override
    public SubjectReference asSubjectReference() {
        Optional<PermissionService> serv;
        if (this.thisSubject == null && (serv = SpongeImpl.getGame().getServiceManager().provide(PermissionService.class)).isPresent()) {
            new SubjectSettingCallback(this).test(serv.get());
        }
        if (this.thisSubject == null) {
            throw new IllegalStateException("No subject reference present for user " + this);
        }
        return this.thisSubject;
    }

    @Override
    public boolean isSubjectDataPersisted() {
        Subject subj = this.resolveNullable();
        return subj != null && subj.isSubjectDataPersisted();
    }

    @Override
    public Set<Context> getActiveContexts() {
        Subject subj = this.resolveNullable();
        return subj == null ? Collections.emptySet() : subj.getActiveContexts();
    }

    @Override
    public Optional<String> getFriendlyIdentifier() {
        Subject subj = this.resolveNullable();
        return subj == null ? Optional.empty() : subj.getFriendlyIdentifier();
    }

    @Override
    public SubjectCollection getContainingCollection() {
        return this.resolve().getContainingCollection();
    }

    @Override
    public SubjectData getSubjectData() {
        return this.resolve().getSubjectData();
    }

    @Override
    public SubjectData getTransientSubjectData() {
        return this.resolve().getTransientSubjectData();
    }

    @Override
    public Tristate getPermissionValue(Set<Context> contexts, String permission) {
        Subject subj = this.resolveNullable();
        if (subj == null) {
            return this.permDefault(permission);
        }
        return subj.getPermissionValue(contexts, permission);
    }

    @Override
    public boolean hasPermission(Set<Context> contexts, String permission) {
        Subject subj = this.resolveNullable();
        if (subj == null) {
            return this.permDefault(permission).asBoolean();
        }
        Tristate ret = this.getPermissionValue(contexts, permission);
        switch (ret) {
            case UNDEFINED: {
                return this.permDefault(permission).asBoolean();
            }
        }
        return ret.asBoolean();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.hasPermission(this.getActiveContexts(), permission);
    }

    @Override
    public boolean isChildOf(Set<Context> contexts, SubjectReference parent) {
        return this.resolve().isChildOf(contexts, parent);
    }

    @Override
    public boolean isChildOf(SubjectReference parent) {
        return this.resolve().isChildOf(parent);
    }

    @Override
    public List<SubjectReference> getParents(Set<Context> contexts) {
        return this.resolve().getParents(contexts);
    }

    @Override
    public List<SubjectReference> getParents() {
        return this.resolve().getParents();
    }

    @Override
    public Optional<String> getOption(Set<Context> contexts, String key) {
        return this.resolve().getOption(contexts, key);
    }

    @Override
    public Optional<String> getOption(String key) {
        return this.resolve().getOption(key);
    }
}

