/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.ai;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.ai.Goal;
import org.spongepowered.api.entity.ai.GoalType;
import org.spongepowered.api.entity.ai.task.AITask;
import org.spongepowered.api.entity.ai.task.AITaskType;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ai.AITaskEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.interfaces.ai.IMixinEntityAIBase;
import org.spongepowered.common.interfaces.ai.IMixinEntityAITasks;
import org.spongepowered.common.interfaces.entity.IMixinEntity;

@Mixin(value={EntityAITasks.class})
@Implements(value={@Interface(iface=Goal.class, prefix="goal$")})
public abstract class MixinEntityAITasks
implements IMixinEntityAITasks {
    @Shadow
    @Final
    private Set<EntityAITasks.EntityAITaskEntry> field_75782_a;
    @Shadow
    @Final
    private Set<EntityAITasks.EntityAITaskEntry> field_75780_b;
    private EntityLiving owner;
    private GoalType type;
    private boolean initialized;

    @Shadow
    public abstract void func_75776_a(int var1, EntityAIBase var2);

    public Agent goal$getOwner() {
        return (Agent)this.owner;
    }

    public GoalType goal$getType() {
        return this.getType();
    }

    public Goal<?> goal$addTask(int priority, AITask<?> task) {
        this.func_75776_a(priority, (EntityAIBase)task);
        return (Goal)((Object)this);
    }

    public Goal<?> goal$removeTask(AITask<?> task) {
        this.func_85156_a((EntityAIBase)task);
        return (Goal)((Object)this);
    }

    public Goal<?> goal$removeTasks(AITaskType type) {
        Iterator<EntityAITasks.EntityAITaskEntry> iterator = this.field_75782_a.iterator();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = iterator.next();
            EntityAIBase otherAiBase = entityaitaskentry.field_75733_a;
            AITask otherTask = (AITask)otherAiBase;
            if (!otherTask.getType().equals(type)) continue;
            if (this.field_75780_b.contains(entityaitaskentry)) {
                otherAiBase.func_75251_c();
                this.field_75780_b.remove(entityaitaskentry);
            }
            iterator.remove();
        }
        return (Goal)((Object)this);
    }

    public List<? extends AITask<?>> goal$getTasksByType(AITaskType type) {
        ImmutableList.Builder tasks = ImmutableList.builder();
        for (EntityAITasks.EntityAITaskEntry entry : this.field_75782_a) {
            AITask task = (AITask)entry.field_75733_a;
            if (!task.getType().equals(type)) continue;
            tasks.add((Object)task);
        }
        return tasks.build();
    }

    public List<? extends AITask<?>> goal$getTasks() {
        ImmutableList.Builder tasks = ImmutableList.builder();
        Iterator<EntityAITasks.EntityAITaskEntry> iterator = this.field_75782_a.iterator();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry o;
            EntityAITasks.EntityAITaskEntry entry = o = iterator.next();
            tasks.add((Object)((AITask)entry.field_75733_a));
        }
        return tasks.build();
    }

    @Override
    public Set<EntityAITasks.EntityAITaskEntry> getTasksUnsafe() {
        return this.field_75782_a;
    }

    @Redirect(method={"addTask"}, at=@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z", remap=false))
    private boolean onAddEntityTask(Set<EntityAITasks.EntityAITaskEntry> set, Object entry, int priority, EntityAIBase base) {
        ((IMixinEntityAIBase)base).setGoal((Goal)((Object)this));
        if (!ShouldFire.AI_TASK_EVENT_ADD || this.owner == null || ((IMixinEntity)this.owner).isInConstructPhase()) {
            EntityAITasks entityAITasks = (EntityAITasks)this;
            entityAITasks.getClass();
            return set.add(new EntityAITasks.EntityAITaskEntry(entityAITasks, priority, base));
        }
        AITaskEvent.Add event = SpongeEventFactory.createAITaskEventAdd(Sponge.getCauseStackManager().getCurrentCause(), priority, priority, (Goal)((Object)this), (Agent)this.owner, (AITask)base);
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            ((IMixinEntityAIBase)base).setGoal(null);
            return false;
        }
        EntityAITasks entityAITasks = (EntityAITasks)this;
        entityAITasks.getClass();
        return set.add(new EntityAITasks.EntityAITaskEntry(entityAITasks, event.getPriority(), base));
    }

    @Override
    public EntityLiving getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(EntityLiving owner) {
        this.owner = owner;
    }

    @Override
    public GoalType getType() {
        return this.type;
    }

    @Override
    public void setType(GoalType type) {
        this.type = type;
    }

    public void goal$clear() {
        this.field_75782_a.clear();
    }

    @Overwrite
    public void func_85156_a(EntityAIBase aiBase) {
        Iterator<EntityAITasks.EntityAITaskEntry> iterator = this.field_75782_a.iterator();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = iterator.next();
            EntityAIBase otherAiBase = entityaitaskentry.field_75733_a;
            if (!otherAiBase.equals(aiBase)) continue;
            Cancellable event = null;
            if (ShouldFire.AI_TASK_EVENT_REMOVE && this.owner != null && !((IMixinEntity)this.owner).isInConstructPhase()) {
                event = SpongeEventFactory.createAITaskEventRemove(Sponge.getCauseStackManager().getCurrentCause(), (Goal)((Object)this), (Agent)this.owner, (AITask)otherAiBase, entityaitaskentry.field_75731_b);
                SpongeImpl.postEvent((Event)((Object)event));
            }
            if (event != null && event.isCancelled()) continue;
            if (entityaitaskentry.field_188524_c) {
                entityaitaskentry.field_188524_c = false;
                otherAiBase.func_75251_c();
                this.field_75780_b.remove(entityaitaskentry);
            }
            iterator.remove();
            return;
        }
    }

    @Overwrite
    private boolean func_75777_a(EntityAITasks.EntityAITaskEntry taskEntry1, EntityAITasks.EntityAITaskEntry taskEntry2) {
        return ((AITask)taskEntry2.field_75733_a).canRunConcurrentWith((AITask)taskEntry1.field_75733_a);
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getOwner()).addValue((Object)this.getType()).toString();
    }
}

