/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.effect;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.entity.ExpirableData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.entity.weather.Lightning;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeExpirableData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.interfaces.entity.IMixinEntityLightningBolt;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.mixin.core.entity.effect.MixinEntityWeatherEffect;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={EntityLightningBolt.class})
public abstract class MixinEntityLightningBolt
extends MixinEntityWeatherEffect
implements Lightning,
IMixinEntityLightningBolt {
    private final List<org.spongepowered.api.entity.Entity> struckEntities = Lists.newArrayList();
    private final List<Transaction<BlockSnapshot>> struckBlocks = Lists.newArrayList();
    private boolean effect = false;
    @Shadow
    private int field_70262_b;

    @Override
    public boolean isEffect() {
        return this.effect;
    }

    @Override
    public void setEffect(boolean effect) {
        this.effect = effect;
        if (effect) {
            this.struckBlocks.clear();
            this.struckEntities.clear();
        }
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"))
    public boolean onStrikeBlockInit(World world, BlockPos pos, IBlockState blockState) {
        return this.onStrikeBlock(world, pos, blockState);
    }

    @Redirect(method={"onUpdate()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"))
    public boolean onStrikeBlockUpdate(World world, BlockPos pos, IBlockState blockState) {
        return this.onStrikeBlock(world, pos, blockState);
    }

    private boolean onStrikeBlock(World world, BlockPos pos, IBlockState blockState) {
        if (!this.effect && ((org.spongepowered.api.world.World)world).containsBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            Vector3i pos3i = VecHelper.toVector3i(pos);
            Transaction<BlockSnapshot> transaction = new Transaction<BlockSnapshot>(new SpongeBlockSnapshotBuilder().blockState((BlockState)world.func_180495_p(pos)).world(((org.spongepowered.api.world.World)world).getProperties()).position(pos3i).build(), new SpongeBlockSnapshotBuilder().blockState((BlockState)blockState).world(((org.spongepowered.api.world.World)world).getProperties()).position(pos3i).build());
            if (!this.struckBlocks.contains(transaction)) {
                this.struckBlocks.add(transaction);
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"onUpdate()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;onStruckByLightning(Lnet/minecraft/entity/effect/EntityLightningBolt;)V"))
    public void onStrikeEntity(Entity mcEntity, EntityLightningBolt lightningBolt) {
        org.spongepowered.api.entity.Entity entity;
        if (!this.effect && !this.struckEntities.contains(entity = (org.spongepowered.api.entity.Entity)mcEntity)) {
            this.struckEntities.add(entity);
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/EntityLightningBolt;setDead()V")})
    public void onLivingTimeExpired(CallbackInfo ci) {
        if (this.field_70128_L) {
            return;
        }
        org.spongepowered.api.world.World world = (org.spongepowered.api.world.World)this.field_70170_p;
        Sponge.getCauseStackManager().pushCause(this);
        LightningEvent.Strike strike = SpongeEventFactory.createLightningEventStrike(Sponge.getCauseStackManager().getCurrentCause(), this.struckEntities, this.struckBlocks);
        Sponge.getEventManager().post(strike);
        if (!strike.isCancelled()) {
            for (Transaction<BlockSnapshot> bt : strike.getTransactions()) {
                if (!bt.isValid()) continue;
                BlockSnapshot bs = bt.getFinal();
                ((WorldServer)world).func_175656_a(((IMixinLocation)((Object)bs.getLocation().get())).getBlockPos(), (IBlockState)bs.getState());
            }
            for (org.spongepowered.api.entity.Entity e : strike.getEntities()) {
                ((Entity)e).func_70077_a((EntityLightningBolt)this);
            }
            SpongeImpl.postEvent(SpongeEventFactory.createLightningEventPost(Sponge.getCauseStackManager().getCurrentCause()));
        }
        Sponge.getCauseStackManager().popCause();
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        if (compound.func_74764_b("effect")) {
            this.effect = compound.func_74767_n("effect");
        }
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        compound.func_74757_a("effect", this.effect);
    }

    @Override
    public ExpirableData getExpiringData() {
        return new SpongeExpirableData(this.field_70262_b, 2);
    }

    @Override
    public MutableBoundedValue<Integer> expireTicks() {
        return SpongeValueFactory.boundedBuilder(Keys.EXPIRATION_TICKS).minimum((Integer)Short.MIN_VALUE).maximum(2).defaultValue(2).actualValue(this.field_70262_b).build();
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(this.getExpiringData());
    }
}

