/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.RepresentedItemData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.config.type.ConfigBase;
import org.spongepowered.common.data.manipulator.mutable.SpongeRepresentedItemData;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.interfaces.entity.item.IMixinEntityItem;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.MixinEntity;

@Mixin(value={EntityItem.class})
public abstract class MixinEntityItem
extends MixinEntity
implements Item,
IMixinEntityItem {
    private static final int MAGIC_PREVIOUS = -1;
    @Shadow
    private int field_145804_b;
    @Shadow
    private int field_70292_b;
    private double cachedRadius = -1.0;
    private int previousPickupDelay = -1;
    private boolean infinitePickupDelay;
    private int previousDespawnDelay = -1;
    private boolean infiniteDespawnDelay;
    public float dropChance = 1.0f;

    @Shadow
    public abstract ItemStack func_92059_d();

    @Override
    public boolean infinitePickupDelay() {
        return this.infinitePickupDelay;
    }

    @ModifyConstant(method={"searchForOtherItemsNearby"}, constant={@Constant(doubleValue=0.5)})
    private double getSearchRadius(double originalRadius) {
        if (this.field_70170_p.field_72995_K || ((IMixinWorld)this.field_70170_p).isFake()) {
            return originalRadius;
        }
        if (this.cachedRadius == -1.0) {
            double configRadius = ((ConfigBase)((IMixinWorldServer)this.field_70170_p).getActiveConfig().getConfig()).getWorld().getItemMergeRadius();
            this.cachedRadius = configRadius < 0.0 ? 0.0 : configRadius;
        }
        return this.cachedRadius;
    }

    @Override
    public int getPickupDelay() {
        return this.infinitePickupDelay ? this.previousPickupDelay : this.field_145804_b;
    }

    @Override
    public void setPickupDelay(int delay, boolean infinite) {
        this.field_145804_b = delay;
        boolean previous = this.infinitePickupDelay;
        this.infinitePickupDelay = infinite;
        if (infinite && !previous) {
            this.previousPickupDelay = this.field_145804_b;
            this.field_145804_b = Short.MAX_VALUE;
        } else if (!infinite) {
            this.previousPickupDelay = -1;
        }
    }

    @Override
    public boolean infiniteDespawnDelay() {
        return this.infiniteDespawnDelay;
    }

    @Override
    public int getDespawnDelay() {
        return this.infiniteDespawnDelay ? this.previousDespawnDelay : this.field_70292_b;
    }

    @Override
    public void setDespawnDelay(int delay, boolean infinite) {
        this.field_70292_b = delay;
        boolean previous = this.infiniteDespawnDelay;
        this.infiniteDespawnDelay = infinite;
        if (infinite && !previous) {
            this.previousDespawnDelay = this.field_70292_b;
            this.field_70292_b = Short.MIN_VALUE;
        } else if (!infinite) {
            this.previousDespawnDelay = -1;
        }
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        this.infinitePickupDelay = compound.func_74767_n("InfinitePickupDelay");
        this.previousPickupDelay = compound.func_150297_b("PreviousPickupDelay", 99) ? compound.func_74762_e("PreviousPickupDelay") : -1;
        this.infiniteDespawnDelay = compound.func_74767_n("InfiniteDespawnDelay");
        this.previousDespawnDelay = compound.func_150297_b("PreviousDespawnDelay", 99) ? compound.func_74762_e("PreviousDespawnDelay") : -1;
        if (this.infinitePickupDelay) {
            if (this.previousPickupDelay != this.field_145804_b) {
                this.previousPickupDelay = this.field_145804_b;
            }
            this.field_145804_b = Short.MAX_VALUE;
        } else if (this.field_145804_b == Short.MAX_VALUE && this.previousPickupDelay != -1) {
            this.field_145804_b = this.previousPickupDelay;
            this.previousPickupDelay = -1;
        }
        if (this.infiniteDespawnDelay) {
            if (this.previousDespawnDelay != this.field_70292_b) {
                this.previousDespawnDelay = this.field_70292_b;
            }
            this.field_70292_b = Short.MIN_VALUE;
        } else if (this.field_70292_b == Short.MIN_VALUE && this.previousDespawnDelay != -1) {
            this.field_70292_b = this.previousDespawnDelay;
            this.previousDespawnDelay = -1;
        }
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        compound.func_74757_a("InfinitePickupDelay", this.infinitePickupDelay);
        compound.func_74777_a("PreviousPickupDelay", (short)this.previousPickupDelay);
        compound.func_74757_a("InfiniteDespawnDelay", this.infiniteDespawnDelay);
        compound.func_74777_a("PreviousDespawnDelay", (short)this.previousDespawnDelay);
    }

    @Override
    public Translation getTranslation() {
        return ((ItemStackSnapshot)this.getItemData().item().get()).getType().getTranslation();
    }

    @Override
    public ItemType getItemType() {
        return (ItemType)this.func_92059_d().func_77973_b();
    }

    @Inject(method={"onCollideWithPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityItem;getItem()Lnet/minecraft/item/ItemStack;")}, cancellable=true)
    public void onPlayerItemPickup(EntityPlayer entityIn, CallbackInfo ci) {
        if (!SpongeCommonEventFactory.callPlayerChangeInventoryPickupEvent(entityIn, (EntityItem)this, this.field_145804_b, this.getCreator().orElse(null))) {
            ci.cancel();
        }
    }

    @Override
    public RepresentedItemData getItemData() {
        return new SpongeRepresentedItemData(ItemStackUtil.snapshotOf(this.func_92059_d()));
    }

    @Override
    public Value<ItemStackSnapshot> item() {
        return new SpongeValue<ItemStackSnapshot>(Keys.REPRESENTED_ITEM, ItemStackSnapshot.NONE, ItemStackUtil.snapshotOf(this.func_92059_d()));
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(this.getItemData());
    }
}

