/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.projectile.explosive.fireball.LargeFireball;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.interfaces.entity.IMixinGriefer;
import org.spongepowered.common.interfaces.entity.explosive.IMixinExplosive;
import org.spongepowered.common.mixin.core.entity.projectile.MixinEntityFireball;

@Mixin(value={EntityLargeFireball.class})
public abstract class MixinEntityLargeFireball
extends MixinEntityFireball
implements LargeFireball,
IMixinExplosive {
    private static final String TARGET_NEW_EXPLOSION = "Lnet/minecraft/world/World;newExplosion(Lnet/minecraft/entity/Entity;DDDFZZ)Lnet/minecraft/world/Explosion;";
    private static final int DEFAULT_EXPLOSION_RADIUS = 1;
    @Shadow
    public int field_92057_e;

    @Redirect(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Ljava/lang/String;)Z"))
    private boolean onCanGrief(GameRules gameRules, String rule) {
        return gameRules.func_82766_b(rule) && ((IMixinGriefer)((Object)this)).canGrief();
    }

    @Override
    public Optional<Integer> getExplosionRadius() {
        return Optional.of(this.field_92057_e);
    }

    @Override
    public void setExplosionRadius(Optional<Integer> radius) {
        this.field_92057_e = radius.orElse(1);
    }

    @Override
    public void detonate() {
        this.onExplode(this.field_70170_p, null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_92057_e, true, true);
        this.func_70106_y();
    }

    @Redirect(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;newExplosion(Lnet/minecraft/entity/Entity;DDDFZZ)Lnet/minecraft/world/Explosion;"))
    protected net.minecraft.world.Explosion onExplode(World worldObj, @Nullable Entity nil, double x, double y, double z, float strength, boolean flaming, boolean smoking) {
        boolean griefer = ((IMixinGriefer)((Object)this)).canGrief();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(this);
            Sponge.getCauseStackManager().addContext(EventContextKeys.THROWER, this.getShooter());
            Sponge.getCauseStackManager().pushCause(this.getShooter());
            Optional<net.minecraft.world.Explosion> ex = this.detonate(Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldObj, new Vector3d(x, y, z))).sourceExplosive(this).radius(strength).canCauseFire(flaming && griefer).shouldPlaySmoke(smoking && griefer).shouldBreakBlocks(smoking && griefer));
            net.minecraft.world.Explosion explosion = ex.orElse(null);
            return explosion;
        }
    }
}

