/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.recipe.smelting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipe;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipeRegistry;
import org.spongepowered.api.item.recipe.smelting.SmeltingResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.item.recipe.smelting.MatchSmeltingVanillaItemStack;
import org.spongepowered.common.item.recipe.smelting.SpongeSmeltingRecipe;

@Mixin(value={FurnaceRecipes.class})
public abstract class MixinFurnaceRecipes
implements SmeltingRecipeRegistry {
    @Shadow
    @Final
    private Map<ItemStack, ItemStack> field_77604_b;
    @Shadow
    @Final
    private Map<ItemStack, Float> field_77605_c;
    private final List<SmeltingRecipe> customRecipes = Lists.newArrayList();
    private final Map<SmeltingRecipe, ItemStack> customRecipeToNativeIngredient = new IdentityHashMap<SmeltingRecipe, ItemStack>();
    private final Map<ItemStack, SmeltingRecipe> nativeIngredientToCustomRecipe = new IdentityHashMap<ItemStack, SmeltingRecipe>();

    @Shadow
    public abstract ItemStack func_151395_a(ItemStack var1);

    @Shadow
    public abstract float func_151398_b(ItemStack var1);

    @Shadow
    private boolean func_151397_a(ItemStack stack1, ItemStack stack2) {
        throw new IllegalStateException("unreachable");
    }

    @Inject(method={"getSmeltingResult"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetSmeltingResult(ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        ItemStackSnapshot ingredient = ItemStackUtil.snapshotOf(stack);
        Optional<SmeltingResult> result = this.getCustomResult(ingredient);
        if (result.isPresent()) {
            ItemStack nativeResult = ItemStackUtil.fromSnapshotToNative(result.get().getResult());
            cir.setReturnValue(nativeResult);
        } else {
            for (ItemStack nativeIngredient : this.nativeIngredientToCustomRecipe.keySet()) {
                if (!this.func_151397_a(nativeIngredient, stack)) continue;
                cir.setReturnValue(ItemStack.field_190927_a);
                return;
            }
        }
    }

    @Inject(method={"getSmeltingExperience"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetSmeltingExperience(ItemStack stack, CallbackInfoReturnable<Float> cir) {
        ItemStackSnapshot ingredient = ItemStackUtil.snapshotOf(stack);
        Optional<SmeltingResult> result = this.getCustomResult(ingredient);
        if (result.isPresent()) {
            float nativeResult = (float)result.get().getExperience();
            cir.setReturnValue(Float.valueOf(nativeResult));
        }
    }

    private Optional<SmeltingResult> getCustomResult(ItemStackSnapshot ingredient) {
        Preconditions.checkNotNull((Object)ingredient, (Object)"ingredient");
        for (SmeltingRecipe recipe : this.customRecipes) {
            Optional<SmeltingResult> result = recipe.getResult(ingredient);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public Optional<SmeltingRecipe> findMatchingRecipe(ItemStackSnapshot ingredient) {
        Preconditions.checkNotNull((Object)ingredient, (Object)"ingredient");
        for (SmeltingRecipe customRecipe : this.customRecipes) {
            if (!customRecipe.isValid(ingredient)) continue;
            return Optional.of(customRecipe);
        }
        ItemStack nativeIngredient = ItemStackUtil.fromSnapshotToNative(ingredient);
        for (Map.Entry<ItemStack, ItemStack> entry : this.field_77604_b.entrySet()) {
            ItemStack nativeIngredientPrecise = entry.getKey();
            if (!this.func_151397_a(nativeIngredient, nativeIngredientPrecise)) continue;
            ItemStack nativeExemplaryResult = entry.getValue();
            ItemStackSnapshot result = ItemStackUtil.snapshotOf(nativeExemplaryResult);
            ItemStackSnapshot ingredientPrecise = ItemStackUtil.snapshotOf(nativeIngredientPrecise);
            MatchSmeltingVanillaItemStack ingredientPredicate = new MatchSmeltingVanillaItemStack(ingredientPrecise);
            double experience = this.field_77605_c.get(nativeExemplaryResult).floatValue();
            SpongeSmeltingRecipe recipe = new SpongeSmeltingRecipe(result, ingredientPrecise, ingredientPredicate, experience);
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    @Override
    public void register(SmeltingRecipe recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"recipe");
        Preconditions.checkArgument((!this.customRecipeToNativeIngredient.containsKey(recipe) ? 1 : 0) != 0, (Object)"This recipe has already been registered!");
        ItemStackSnapshot exemplaryIngredient = recipe.getExemplaryIngredient();
        ItemStack nativeExemplaryIngredient = ItemStackUtil.fromSnapshotToNative(exemplaryIngredient);
        ItemStack nativeExemplaryResult = ItemStackUtil.fromSnapshotToNative(recipe.getExemplaryResult());
        float nativeExemplaryExperience = (float)recipe.getResult(exemplaryIngredient).orElseThrow(() -> new IllegalStateException("Could not get the result for the exemplary ingredient.")).getExperience();
        this.field_77604_b.put(nativeExemplaryIngredient, nativeExemplaryResult);
        this.field_77605_c.put(nativeExemplaryResult, Float.valueOf(nativeExemplaryExperience));
        this.customRecipeToNativeIngredient.put(recipe, nativeExemplaryIngredient);
        this.nativeIngredientToCustomRecipe.put(nativeExemplaryIngredient, recipe);
        this.customRecipes.add(recipe);
    }

    @Override
    public Collection<SmeltingRecipe> getRecipes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<ItemStack, ItemStack> smeltingEntry : this.field_77604_b.entrySet()) {
            ItemStack nativeIngredient = smeltingEntry.getKey();
            if (this.nativeIngredientToCustomRecipe.containsKey(nativeIngredient)) continue;
            ItemStack nativeExemplaryResult = smeltingEntry.getValue();
            ItemStackSnapshot exemplaryResult = ItemStackUtil.snapshotOf(nativeExemplaryResult);
            ItemStackSnapshot exemplaryIngredient = ItemStackUtil.snapshotOf(nativeIngredient);
            MatchSmeltingVanillaItemStack ingredientPredicate = new MatchSmeltingVanillaItemStack(exemplaryIngredient);
            double experience = this.field_77605_c.get(nativeExemplaryResult).floatValue();
            builder.add((Object)new SpongeSmeltingRecipe(exemplaryResult, exemplaryIngredient, ingredientPredicate, experience));
        }
        builder.addAll(this.customRecipes);
        return builder.build();
    }
}

