/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.status;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import net.minecraft.network.LegacyPingHandler;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.network.status.SpongeLegacyMinecraftVersion;
import org.spongepowered.common.network.status.SpongeStatusResponse;
import org.spongepowered.common.util.NetworkUtil;

@Mixin(value={LegacyPingHandler.class})
public abstract class MixinLegacyPingHandler
extends ChannelInboundHandlerAdapter {
    @Shadow
    @Final
    private static Logger field_151258_a;
    @Shadow
    @Final
    private NetworkSystem field_151257_b;
    private ByteBuf buf;

    @Shadow
    private void func_151256_a(ChannelHandlerContext ctx, ByteBuf data) {
    }

    @Shadow
    private ByteBuf func_151255_a(String string) {
        return null;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.buf = ctx.alloc().buffer();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.buf != null) {
            this.buf.release();
            this.buf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf m = (ByteBuf)msg;
        this.buf.writeBytes(m);
        m.release();
        this.buf.markReaderIndex();
        boolean result = false;
        try {
            result = this.readLegacy(ctx, this.buf);
        }
        finally {
            this.buf.resetReaderIndex();
            if (!result) {
                ByteBuf buf = this.buf;
                this.buf = null;
                ctx.pipeline().remove("legacy_query");
                ctx.fireChannelRead((Object)buf);
            }
        }
    }

    private boolean readLegacy(ChannelHandlerContext ctx, ByteBuf buf) {
        if (buf.readUnsignedByte() != 254) {
            return false;
        }
        MinecraftServer server = this.field_151257_b.func_151267_d();
        InetSocketAddress client = (InetSocketAddress)ctx.channel().remoteAddress();
        int i = buf.readableBytes();
        switch (i) {
            case 0: {
                field_151258_a.debug("Ping: (<=1.3) from {}:{}", (Object)client.getAddress(), (Object)client.getPort());
                ServerStatusResponse response = SpongeStatusResponse.postLegacy(server, client, SpongeLegacyMinecraftVersion.V1_3, null);
                if (response != null) {
                    this.writeResponse(ctx, String.format("%s\u00a7%d\u00a7%d", SpongeStatusResponse.getUnformattedMotd(response), response.func_151318_b().func_151333_b(), response.func_151318_b().func_151332_a()));
                    break;
                }
                ctx.close();
                break;
            }
            case 1: {
                if (buf.readUnsignedByte() != 1) {
                    return false;
                }
                field_151258_a.debug("Ping: (1.4-1.5) from {}:{}", (Object)client.getAddress(), (Object)client.getPort());
                ServerStatusResponse response = SpongeStatusResponse.postLegacy(server, client, SpongeLegacyMinecraftVersion.V1_5, null);
                if (response != null) {
                    this.writeResponse(ctx, String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", response.func_151322_c().func_151304_b(), response.func_151322_c().func_151303_a(), SpongeStatusResponse.getMotd(response), response.func_151318_b().func_151333_b(), response.func_151318_b().func_151332_a()));
                    break;
                }
                ctx.close();
                break;
            }
            default: {
                short length;
                if (buf.readUnsignedByte() != 1 || buf.readUnsignedByte() != 250) {
                    return false;
                }
                if (!buf.isReadable(2) || !buf.isReadable((length = buf.readShort()) * 2)) break;
                if (!buf.readBytes(length * 2).toString(Charsets.UTF_16BE).equals("MC|PingHost")) {
                    return false;
                }
                if (!buf.isReadable(2) || !buf.isReadable((int)(length = buf.readShort()))) break;
                short protocol = buf.readUnsignedByte();
                length = buf.readShort();
                String host = buf.readBytes(length * 2).toString(Charsets.UTF_16BE);
                int port = buf.readInt();
                field_151258_a.debug("Ping: (1.6) from {}:{}", (Object)client.getAddress(), (Object)client.getPort());
                ServerStatusResponse response = SpongeStatusResponse.postLegacy(server, client, new SpongeLegacyMinecraftVersion(SpongeLegacyMinecraftVersion.V1_6, (int)protocol), InetSocketAddress.createUnresolved(NetworkUtil.cleanVirtualHost(host), port));
                if (response != null) {
                    this.writeResponse(ctx, String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", response.func_151322_c().func_151304_b(), response.func_151322_c().func_151303_a(), SpongeStatusResponse.getMotd(response), response.func_151318_b().func_151333_b(), response.func_151318_b().func_151332_a()));
                    break;
                }
                ctx.close();
            }
        }
        return true;
    }

    private void writeResponse(ChannelHandlerContext ctx, String response) {
        this.func_151256_a(ctx, this.func_151255_a(response));
    }
}

