/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImplHooks;

@Mixin(value={BlockRedstoneWire.class}, priority=1001)
public abstract class MixinBlockRedstoneWire
extends Block {
    private List<BlockPos> turnOff = Lists.newArrayList();
    private List<BlockPos> turnOn = Lists.newArrayList();
    private final Set<BlockPos> updatedRedstoneWire = Sets.newLinkedHashSet();
    private static final EnumFacing[] facingsHorizontal = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH};
    private static final EnumFacing[] facingsVertical = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
    private static final EnumFacing[] facings = (EnumFacing[])ArrayUtils.addAll((Object[])facingsVertical, (Object[])facingsHorizontal);
    private static final Vec3i[] surroundingBlocksOffset;
    @Shadow
    public boolean field_150181_a;

    protected MixinBlockRedstoneWire(Material materialIn) {
        super(materialIn);
    }

    @Shadow
    public abstract int func_176342_a(World var1, BlockPos var2, int var3);

    @Shadow
    public abstract boolean func_176339_d(IBlockAccess var1, BlockPos var2, EnumFacing var3);

    @Inject(method={"updateSurroundingRedstone"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateSurroundingRedstone(World worldIn, BlockPos pos, IBlockState state, CallbackInfoReturnable<IBlockState> cir) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos);
            cir.setReturnValue(state);
        }
    }

    @Inject(method={"calculateCurrentChanges"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCalculateCurrentChanges(World worldIn, BlockPos pos1, BlockPos pos2, IBlockState state, CallbackInfoReturnable<IBlockState> cir) {
        if (!worldIn.field_72995_K) {
            this.calculateCurrentChanges(worldIn, pos1);
            cir.setReturnValue(state);
        }
    }

    private void updateSurroundingRedstone(World worldIn, BlockPos pos) {
        this.calculateCurrentChanges(worldIn, pos);
        LinkedHashSet blocksNeedingUpdate = Sets.newLinkedHashSet();
        for (BlockPos posi : this.updatedRedstoneWire) {
            this.addBlocksNeedingUpdate(worldIn, posi, blocksNeedingUpdate);
        }
        Iterator it = Lists.newLinkedList(this.updatedRedstoneWire).descendingIterator();
        while (it.hasNext()) {
            this.addAllSurroundingBlocks((BlockPos)it.next(), blocksNeedingUpdate);
        }
        blocksNeedingUpdate.removeAll(this.updatedRedstoneWire);
        this.updatedRedstoneWire.clear();
        for (BlockPos posi : blocksNeedingUpdate) {
            worldIn.func_175685_c(posi, (Block)((BlockRedstoneWire)this), false);
        }
    }

    private void calculateCurrentChanges(World worldIn, BlockPos position) {
        int newPower;
        int wirePower;
        int blockPower;
        int oldPower;
        IBlockState state;
        BlockPos pos;
        if (worldIn.func_180495_p(position).func_177230_c() == (BlockRedstoneWire)this) {
            this.turnOff.add(position);
        } else {
            this.checkSurroundingWires(worldIn, position);
        }
        while (!this.turnOff.isEmpty()) {
            pos = this.turnOff.remove(0);
            state = worldIn.func_180495_p(pos);
            oldPower = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            this.field_150181_a = false;
            blockPower = worldIn.func_175687_A(pos);
            this.field_150181_a = true;
            wirePower = this.getSurroundingWirePower(worldIn, pos);
            if ((newPower = Math.max(blockPower, --wirePower)) < oldPower) {
                if (blockPower > 0 && !this.turnOn.contains(pos)) {
                    this.turnOn.add(pos);
                }
                this.setWireState(worldIn, pos, state, 0);
            } else if (newPower > oldPower) {
                this.setWireState(worldIn, pos, state, newPower);
            }
            this.checkSurroundingWires(worldIn, pos);
        }
        while (!this.turnOn.isEmpty()) {
            pos = this.turnOn.remove(0);
            state = worldIn.func_180495_p(pos);
            oldPower = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            this.field_150181_a = false;
            blockPower = worldIn.func_175687_A(pos);
            this.field_150181_a = true;
            wirePower = this.getSurroundingWirePower(worldIn, pos);
            if ((newPower = Math.max(blockPower, --wirePower)) > oldPower) {
                this.setWireState(worldIn, pos, state, newPower);
            } else if (newPower < oldPower) {
                // empty if block
            }
            this.checkSurroundingWires(worldIn, pos);
        }
        this.turnOff.clear();
        this.turnOn.clear();
    }

    private void addWireToList(World worldIn, BlockPos pos, int otherPower) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == (BlockRedstoneWire)this) {
            int power = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            if (power < otherPower - 1 && !this.turnOn.contains(pos)) {
                this.turnOn.add(pos);
            }
            if (power > otherPower && !this.turnOff.contains(pos)) {
                this.turnOff.add(pos);
            }
        }
    }

    private void checkSurroundingWires(World worldIn, BlockPos pos) {
        BlockPos offsetPos;
        IBlockState state = worldIn.func_180495_p(pos);
        int ownPower = 0;
        if (state.func_177230_c() == (BlockRedstoneWire)this) {
            ownPower = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        }
        for (EnumFacing facing : facingsHorizontal) {
            offsetPos = pos.func_177972_a(facing);
            if (!facing.func_176740_k().func_176722_c()) continue;
            this.addWireToList(worldIn, offsetPos, ownPower);
        }
        for (EnumFacing facingVertical : facingsVertical) {
            offsetPos = pos.func_177972_a(facingVertical);
            boolean solidBlock = worldIn.func_180495_p(offsetPos).func_185898_k();
            for (EnumFacing facingHorizontal : facingsHorizontal) {
                if ((facingVertical != EnumFacing.UP || solidBlock) && (facingVertical != EnumFacing.DOWN || !solidBlock || worldIn.func_180495_p(offsetPos.func_177972_a(facingHorizontal)).func_185898_k())) continue;
                this.addWireToList(worldIn, offsetPos.func_177972_a(facingHorizontal), ownPower);
            }
        }
    }

    private int getSurroundingWirePower(World worldIn, BlockPos pos) {
        int wirePower = 0;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(enumfacing);
            wirePower = this.func_176342_a(worldIn, offsetPos, wirePower);
            if (worldIn.func_180495_p(offsetPos).func_185915_l() && !worldIn.func_180495_p(pos.func_177984_a()).func_185915_l()) {
                wirePower = this.func_176342_a(worldIn, offsetPos.func_177984_a(), wirePower);
                continue;
            }
            if (worldIn.func_180495_p(offsetPos).func_185915_l()) continue;
            wirePower = this.func_176342_a(worldIn, offsetPos.func_177977_b(), wirePower);
        }
        return wirePower;
    }

    private void addBlocksNeedingUpdate(World worldIn, BlockPos pos, Set<BlockPos> set) {
        BlockPos offsetPos;
        List<EnumFacing> connectedSides = this.getSidesToPower(worldIn, pos);
        for (EnumFacing facing : facings) {
            offsetPos = pos.func_177972_a(facing);
            if (!connectedSides.contains(facing.func_176734_d()) && facing != EnumFacing.DOWN && (!facing.func_176740_k().func_176722_c() || !MixinBlockRedstoneWire.canConnectToBlock(worldIn.func_180495_p(offsetPos), facing, (IBlockAccess)worldIn, pos)) || !this.canBlockBePoweredFromSide(worldIn.func_180495_p(offsetPos), facing, true)) continue;
            set.add(offsetPos);
        }
        for (EnumFacing facing : facings) {
            offsetPos = pos.func_177972_a(facing);
            if (!connectedSides.contains(facing.func_176734_d()) && facing != EnumFacing.DOWN || !worldIn.func_180495_p(offsetPos).func_185915_l()) continue;
            for (EnumFacing facing1 : facings) {
                if (!this.canBlockBePoweredFromSide(worldIn.func_180495_p(offsetPos.func_177972_a(facing1)), facing1, false)) continue;
                set.add(offsetPos.func_177972_a(facing1));
            }
        }
    }

    private boolean canBlockBePoweredFromSide(IBlockState state, EnumFacing side, boolean isWire) {
        if (state.func_177230_c() instanceof BlockPistonBase && state.func_177229_b((IProperty)BlockPistonBase.field_176387_N) == side.func_176734_d()) {
            return false;
        }
        if (state.func_177230_c() instanceof BlockRedstoneDiode && state.func_177229_b((IProperty)BlockRedstoneDiode.field_185512_D) != side.func_176734_d()) {
            return isWire && state.func_177230_c() instanceof BlockRedstoneComparator && ((EnumFacing)state.func_177229_b((IProperty)BlockRedstoneComparator.field_185512_D)).func_176740_k() != side.func_176740_k() && side.func_176740_k().func_176722_c();
        }
        return !(state.func_177230_c() instanceof BlockRedstoneTorch) || !isWire && state.func_177229_b((IProperty)BlockRedstoneTorch.field_176596_a) == side;
    }

    private List<EnumFacing> getSidesToPower(World worldIn, BlockPos pos) {
        boolean eastwest;
        ArrayList retval = Lists.newArrayList();
        for (EnumFacing facing : facingsHorizontal) {
            if (!this.func_176339_d((IBlockAccess)worldIn, pos, facing)) continue;
            retval.add(facing);
        }
        if (retval.isEmpty()) {
            return Lists.newArrayList((Object[])facingsHorizontal);
        }
        boolean northsouth = retval.contains(EnumFacing.NORTH) || retval.contains(EnumFacing.SOUTH);
        boolean bl = eastwest = retval.contains(EnumFacing.EAST) || retval.contains(EnumFacing.WEST);
        if (northsouth) {
            retval.remove(EnumFacing.EAST);
            retval.remove(EnumFacing.WEST);
        }
        if (eastwest) {
            retval.remove(EnumFacing.NORTH);
            retval.remove(EnumFacing.SOUTH);
        }
        return retval;
    }

    private void addAllSurroundingBlocks(BlockPos pos, Set<BlockPos> set) {
        for (Vec3i vect : surroundingBlocksOffset) {
            set.add(pos.func_177971_a(vect));
        }
    }

    private void setWireState(World worldIn, BlockPos pos, IBlockState state, int power) {
        state = state.func_177226_a((IProperty)BlockRedstoneWire.field_176351_O, (Comparable)Integer.valueOf(power));
        worldIn.func_180501_a(pos, state, 2);
        this.updatedRedstoneWire.add(pos);
    }

    @Overwrite
    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos);
            for (Vec3i vec : surroundingBlocksOffset) {
                worldIn.func_175685_c(pos.func_177971_a(vec), (Block)this, false);
            }
        }
    }

    @Overwrite
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos);
            for (Vec3i vec : surroundingBlocksOffset) {
                worldIn.func_175685_c(pos.func_177971_a(vec), (Block)this, false);
            }
        }
    }

    @Overwrite
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.field_150181_a) {
            return 0;
        }
        if (side == EnumFacing.UP || this.getSidesToPower((World)blockAccess, pos).contains(side)) {
            return (Integer)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        }
        return 0;
    }

    private static boolean canConnectToBlock(IBlockState blockState, @Nullable EnumFacing side, IBlockAccess world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150488_af) {
            return true;
        }
        if (Blocks.field_150413_aR.func_185547_C(blockState)) {
            EnumFacing enumfacing = (EnumFacing)blockState.func_177229_b((IProperty)BlockRedstoneRepeater.field_185512_D);
            return enumfacing == side || enumfacing.func_176734_d() == side;
        }
        if (Blocks.field_190976_dk == blockState.func_177230_c()) {
            return side == blockState.func_177229_b((IProperty)BlockObserver.field_176387_N);
        }
        return SpongeImplHooks.canConnectRedstone(block, blockState, world, pos, side);
    }

    static {
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (EnumFacing facing : facings) {
            set.add(facing.field_176756_m);
        }
        for (EnumFacing facing1 : facings) {
            Vec3i v1 = facing1.field_176756_m;
            for (EnumFacing facing2 : facings) {
                Vec3i v2 = facing2.field_176756_m;
                set.add(new Vec3i(v1.func_177958_n() + v2.func_177958_n(), v1.func_177956_o() + v2.func_177956_o(), v1.func_177952_p() + v2.func_177952_p()));
            }
        }
        set.remove(new Vec3i(0, 0, 0));
        surroundingBlocksOffset = set.toArray(new Vec3i[set.size()]);
    }
}

