/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.common.SpongeImpl;

public class MultiWorldCommandPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PREFIX = "MixinCommand";
    private boolean configState;

    @Override
    public void onLoad(String mixinPackage) {
        this.configState = mixinPackage.endsWith(".multiworld");
    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Map<String, Boolean> patches;
        String name = StringUtils.substringAfter((String)mixinClassName, (String)MIXIN_PREFIX).toLowerCase(Locale.ENGLISH);
        if (name.equals("showseed")) {
            name = "seed";
        }
        if (!(patches = SpongeImpl.getGlobalConfig().getConfig().getCommands().getMultiWorldCommandPatches()).containsKey(name)) {
            patches.put(name, true);
            SpongeImpl.getGlobalConfig().save();
            return this.configState;
        }
        return patches.get(name) == this.configState;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Override
    public List<String> getMixins() {
        return null;
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

