/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.category.OptimizationCategory;
import org.spongepowered.common.config.type.GlobalConfig;

public class OptimizationPlugin
implements IMixinConfigPlugin {
    private static final Map<String, Function<OptimizationCategory, Boolean>> mixinEnabledMappings = ImmutableMap.builder().put((Object)"org.spongepowered.common.mixin.optimization.MixinExplosion_Explosion", module -> true).put((Object)"org.spongepowered.common.mixin.optimization.MixinSpongeImplHooks_Item_Pre_Merge", OptimizationCategory::doDropsPreMergeItemDrops).put((Object)"org.spongepowered.common.mixin.optimization.MixinWorldServer_Explosion", module -> true).put((Object)"org.spongepowered.common.mixin.optimization.MixinSpongeImplHooks_Explosion", module -> true).put((Object)"org.spongepowered.common.mixin.optimization.block.MixinBlockRedstoneWire", OptimizationCategory::usePandaRedstone).put((Object)"org.spongepowered.common.mixin.optimization.entity.MixinEntityTameable_Cached_Owner", OptimizationCategory::useCacheTameableOwners).put((Object)"org.spongepowered.common.mixin.optimization.world.MixinChunk_Async_Lighting", OptimizationCategory::useAsyncLighting).put((Object)"org.spongepowered.common.mixin.optimization.world.MixinWorldServer_Async_Lighting", OptimizationCategory::useAsyncLighting).put((Object)"org.spongepowered.common.mixin.optimization.world.gen.MixinChunkProviderServer_Async_Lighting", OptimizationCategory::useAsyncLighting).put((Object)"org.spongepowered.common.mixin.optimization.world.gen.structure.MixinMapGenStructure_Structure_Saving", OptimizationCategory::useStructureSave).build();

    @Override
    public void onLoad(String mixinPackage) {
    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        GlobalConfig globalConfig = SpongeImpl.getGlobalConfig().getConfig();
        if (globalConfig.getModules().useOptimizations()) {
            Function<OptimizationCategory, Boolean> optimizationCategoryBooleanFunction = mixinEnabledMappings.get(mixinClassName);
            if (optimizationCategoryBooleanFunction == null) {
                new PrettyPrinter(50).add("Could not find function for optimization patch").centre().hr().add("Missing function for class: " + mixinClassName).trace();
            }
            return optimizationCategoryBooleanFunction.apply(globalConfig.getOptimizations());
        }
        return false;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Override
    public List<String> getMixins() {
        return null;
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

