/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile.query;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.common.profile.query.Query;

public abstract class NameQuery<T>
extends Query<T> {
    protected NameQuery(GameProfileCache cache, boolean useCache) {
        super(cache, useCache);
    }

    public static final class MultiGet
    extends NameQuery<Collection<GameProfile>> {
        private final Iterator<String> iterator;

        public MultiGet(GameProfileCache cache, Iterable<String> iterable, boolean useCache) {
            super(cache, useCache);
            this.iterator = iterable.iterator();
        }

        @Override
        public Collection<GameProfile> call() throws Exception {
            if (!this.iterator.hasNext()) {
                return ImmutableSet.of();
            }
            return this.fromNames(Sets.newHashSet(this.iterator));
        }
    }

    public static final class SingleGet
    extends NameQuery<GameProfile> {
        private final String name;

        public SingleGet(GameProfileCache cache, String name, boolean useCache) {
            super(cache, useCache);
            this.name = name;
        }

        @Override
        public GameProfile call() throws Exception {
            return this.fromNames(Collections.singleton(this.name)).get(0);
        }
    }
}

