/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataTranslators;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.persistence.ConfigurateTranslator;
import org.spongepowered.common.data.persistence.DataSerializers;
import org.spongepowered.common.data.persistence.LegacySchematicTranslator;
import org.spongepowered.common.data.persistence.SchematicTranslator;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public class DataTranslatorRegistryModule
implements AlternateCatalogRegistryModule<DataTranslator>,
SpongeAdditionalCatalogRegistryModule<DataTranslator> {
    @RegisterCatalog(value=DataTranslators.class)
    private final Map<String, DataTranslator> dataTranslatorMappings = new HashMap<String, DataTranslator>();

    public static DataTranslatorRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, DataTranslator> provideCatalogMap() {
        HashMap<String, DataTranslator> modifierMap = new HashMap<String, DataTranslator>();
        for (Map.Entry<String, DataTranslator> entry : this.dataTranslatorMappings.entrySet()) {
            modifierMap.put(entry.getKey().replace("sponge:", ""), entry.getValue());
        }
        return modifierMap;
    }

    @Override
    public Optional<DataTranslator> getById(String id) {
        return Optional.ofNullable(this.dataTranslatorMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<DataTranslator> getAll() {
        return ImmutableList.copyOf(this.dataTranslatorMappings.values());
    }

    @Override
    public void registerAdditionalCatalog(DataTranslator extraCatalog) {
        Preconditions.checkNotNull((Object)extraCatalog, (Object)"CatalogType cannot be null");
        Preconditions.checkArgument((!extraCatalog.getId().isEmpty() ? 1 : 0) != 0, (Object)"Id cannot be empty");
        Preconditions.checkArgument((!this.dataTranslatorMappings.containsKey(extraCatalog.getId()) ? 1 : 0) != 0, (Object)"Duplicate Id");
        this.dataTranslatorMappings.put(extraCatalog.getId(), extraCatalog);
    }

    @Override
    public void registerDefaults() {
        DataSerializers.registerSerializers(SpongeImpl.getGame().getDataManager());
        this.registerAdditionalCatalog(LegacySchematicTranslator.get());
        this.registerAdditionalCatalog(SchematicTranslator.get());
        this.registerAdditionalCatalog(ConfigurateTranslator.instance());
    }

    DataTranslatorRegistryModule() {
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    private static final class Holder {
        static final DataTranslatorRegistryModule INSTANCE = new DataTranslatorRegistryModule();

        private Holder() {
        }
    }
}

