/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.effect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.effect.sound.record.RecordType;
import org.spongepowered.api.effect.sound.record.RecordTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.common.effect.record.SpongeRecordType;
import org.spongepowered.common.registry.type.effect.SoundRegistryModule;

@RegistrationDependency(value={SoundRegistryModule.class})
public final class RecordTypeRegistryModule
implements CatalogRegistryModule<RecordType> {
    @RegisterCatalog(value=RecordTypes.class)
    private final Map<String, RecordType> mappings = new HashMap<String, RecordType>();
    private final Int2ObjectMap<RecordType> byInternalId = new Int2ObjectOpenHashMap();

    public static RecordTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    private RecordTypeRegistryModule() {
    }

    public Optional<RecordType> getByInternalId(int internalId) {
        return Optional.ofNullable(this.byInternalId.get(internalId));
    }

    @Override
    public Optional<RecordType> getById(String id) {
        Preconditions.checkNotNull((Object)id);
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.mappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<RecordType> getAll() {
        return ImmutableList.copyOf(this.mappings.values());
    }

    private void add(SpongeRecordType recordType) {
        String id = recordType.getId();
        this.mappings.put(id, recordType);
        this.byInternalId.put(recordType.getInternalId(), (Object)recordType);
    }

    @Override
    public void registerDefaults() {
        this.add(new SpongeRecordType("minecraft:thirteen", "item.record.13.desc", 2256, SoundTypes.RECORD_13));
        this.add(new SpongeRecordType("minecraft:cat", "item.record.cat.desc", 2257, SoundTypes.RECORD_CAT));
        this.add(new SpongeRecordType("minecraft:blocks", "item.record.blocks.desc", 2258, SoundTypes.RECORD_BLOCKS));
        this.add(new SpongeRecordType("minecraft:chirp", "item.record.chirp.desc", 2259, SoundTypes.RECORD_CHIRP));
        this.add(new SpongeRecordType("minecraft:far", "item.record.far.desc", 2260, SoundTypes.RECORD_FAR));
        this.add(new SpongeRecordType("minecraft:mall", "item.record.mall.desc", 2261, SoundTypes.RECORD_MALL));
        this.add(new SpongeRecordType("minecraft:mellohi", "item.record.mellohi.desc", 2262, SoundTypes.RECORD_MELLOHI));
        this.add(new SpongeRecordType("minecraft:stal", "item.record.stal.desc", 2263, SoundTypes.RECORD_STAL));
        this.add(new SpongeRecordType("minecraft:strad", "item.record.strad.desc", 2264, SoundTypes.RECORD_STRAD));
        this.add(new SpongeRecordType("minecraft:ward", "item.record.ward.desc", 2265, SoundTypes.RECORD_WARD));
        this.add(new SpongeRecordType("minecraft:eleven", "item.record.11.desc", 2266, SoundTypes.RECORD_11));
        this.add(new SpongeRecordType("minecraft:wait", "item.record.wait.desc", 2267, SoundTypes.RECORD_WAIT));
    }

    private static final class Holder {
        static final RecordTypeRegistryModule INSTANCE = new RecordTypeRegistryModule();

        private Holder() {
        }
    }
}

